/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.BulkMoveHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DefaultBulkMoveHelper
implements BulkMoveHelper {
    private final BulkEditBeanSessionHelper bulkEditBeanSessionHelper = new BulkEditBeanSessionHelper();

    protected BulkEditBean getBulkEditBeanFromSession() {
        return this.bulkEditBeanSessionHelper.getFromSession();
    }

    public Map<Long, BulkMoveHelper.DistinctValueResult> getDistinctValuesForMove(BulkEditBean bulkEditBean, OrderableField orderableField, Function<Issue, Collection<Object>> issueValueResolution, Function<Object, String> nameResolution) {
        FieldLayoutItem targetFieldLayoutItem = bulkEditBean.getTargetFieldLayout().getFieldLayoutItem(orderableField);
        List issues = bulkEditBean.getSelectedIssues();
        TreeMap<Long, BulkMoveHelper.DistinctValueResult> distinctValues = new TreeMap<Long, BulkMoveHelper.DistinctValueResult>();
        Map fieldSubtitutionMap = (Map)this.getBulkEditBeanFromSession().getFieldSubstitutionMap().get(orderableField.getId());
        for (Issue issue : issues) {
            Issue targetIssue = (Issue)bulkEditBean.getTargetIssueObjects().get(issue);
            if (targetIssue.getProjectId().equals(issue.getProjectId())) continue;
            Collection valuesForIssue = (Collection)issueValueResolution.get((Object)issue);
            if (valuesForIssue.isEmpty()) {
                if (!targetFieldLayoutItem.isRequired()) continue;
                distinctValues.put(-1L, new BulkMoveHelper.DistinctValueResult());
                continue;
            }
            for (Object value : valuesForIssue) {
                boolean isPreviousValueSpecified;
                Long previouslySelectedValue;
                String valueName;
                Long longValue = Long.parseLong(value.toString());
                if (distinctValues.containsKey(longValue) || (valueName = (String)nameResolution.get(value)) == null) continue;
                if (fieldSubtitutionMap != null) {
                    previouslySelectedValue = (Long)fieldSubtitutionMap.get(longValue);
                    isPreviousValueSpecified = fieldSubtitutionMap.containsKey(longValue);
                } else {
                    previouslySelectedValue = null;
                    isPreviousValueSpecified = false;
                }
                distinctValues.put(longValue, new BulkMoveHelper.DistinctValueResult(valueName.trim(), issue.getProjectObject().getName(), previouslySelectedValue, isPreviousValueSpecified));
            }
        }
        return distinctValues;
    }

    public boolean needsSelection(BulkMoveHelper.DistinctValueResult distinctValue, Long id, String valueName) {
        if (distinctValue.isPreviousValueSpecified()) {
            Long previouslySelectedValue = distinctValue.getPreviouslySelectedValue();
            return previouslySelectedValue != null && previouslySelectedValue.equals(id);
        }
        return valueName.trim().equals(distinctValue.getValueName().trim());
    }
}

