/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class ProjectDescriptionRendererBean {
    private final ProjectDescriptionRenderer renderer;

    public ProjectDescriptionRendererBean(@Nonnull ProjectDescriptionRenderer renderer) {
        this.renderer = (ProjectDescriptionRenderer)Assertions.notNull((Object)renderer);
    }

    public ProjectDescriptionRendererBean() {
        this((ProjectDescriptionRenderer)ComponentAccessor.getComponent(ProjectDescriptionRenderer.class));
    }

    public String getViewHtml(@Nonnull GenericValue genericValue) {
        Assertions.notNull((String)"generic value must not be null", (Object)genericValue);
        ProjectImpl project = new ProjectImpl(genericValue);
        return this.getViewHtml(project);
    }

    @Nonnull
    public String getViewHtml(@Nonnull Project project) {
        Assertions.notNull((String)"project must not be null", (Object)project);
        return this.renderDescriptionAsHtml(project);
    }

    @Nonnull
    private String renderDescriptionAsHtml(@Nonnull Project project) {
        return Strings.nullToEmpty((String)this.renderer.getViewHtml(project.getDescription()));
    }
}

