/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.admin.group;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.group.GroupAccessLabelsManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.component.admin.group.GroupLabelView;
import com.atlassian.jira.web.component.admin.group.GroupLabelsService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;

public class DefaultGroupLabelsService
implements GroupLabelsService {
    private final ApplicationRoleManager roleManager;
    private final GroupAccessLabelsManager labelsManager;
    private final JiraAuthenticationContext authenticationContext;

    public DefaultGroupLabelsService(ApplicationRoleManager roleManager, GroupAccessLabelsManager labelsManager, JiraAuthenticationContext authenticationContext) {
        this.roleManager = roleManager;
        this.labelsManager = labelsManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List<GroupLabelView> getGroupLabels(Group group, Optional<Long> directory) {
        List apps;
        Preconditions.checkState((boolean)this.roleManager.rolesEnabled(), (Object)"Roles should be enabled to check labels");
        ImmutableList.Builder labels = ImmutableList.builder();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        GroupAccessLabelsManager.GroupAccessLabels groupLabels = this.labelsManager.getForGroup(group, directory);
        if (groupLabels.isAdmin()) {
            labels.add((Object)new GroupLabelView(i18n.getText("admin.viewgroup.labels.admin.text"), i18n.getText("admin.viewgroup.labels.admin.description"), GroupLabelView.LabelType.ADMIN));
        }
        if ((apps = (List)groupLabels.getAccessibleApplications().stream().collect(CollectorsUtil.toImmutableList())).size() > 0) {
            GroupLabelView.LabelType labelType;
            String labelText = this.getLabelText(apps, i18n);
            GroupLabelView.LabelType labelType2 = labelType = apps.size() == 1 ? GroupLabelView.LabelType.SINGLE : GroupLabelView.LabelType.MULTIPLE;
            if (apps.size() > 5) {
                labels.add((Object)new GroupLabelView(labelText, i18n.getText("admin.viewgroup.labels.application.access.multiple.description"), labelType));
            } else {
                List appNamesHtml = (List)apps.stream().map(this::getXSSSecureBoldApplicationName).collect(CollectorsUtil.toImmutableList());
                labels.add((Object)new GroupLabelView(labelText, i18n.getText("admin.viewgroup.labels.application.access.description." + apps.size() + ".app", (Object)appNamesHtml), labelType));
            }
        }
        return labels.build();
    }

    private String getLabelText(List<ApplicationRole> applicationRoles, I18nHelper i18n) {
        if (applicationRoles.size() == 1) {
            return applicationRoles.get(0).getName();
        }
        return i18n.getText("admin.viewgroup.labels.application.access.multiple.text");
    }

    private String getXSSSecureBoldApplicationName(@Nonnull ApplicationRole applicationRole) {
        return "<strong>" + StringEscapeUtils.escapeHtml4((String)applicationRole.getName()) + "</strong>";
    }
}

