/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.web.dispatcher.ActionViewDataSupport;
import com.atlassian.jira.web.dispatcher.SoyTemplateAddress;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import webwork.config.util.ActionInfo;
import webwork.dispatcher.ActionResult;

class JiraSoyViewDispatcher {
    private final ActionViewDataSupport actionViewDataSupport = new ActionViewDataSupport();

    JiraSoyViewDispatcher() {
    }

    public void dispatch(HttpServletResponse httpServletResponse, ActionResult ar, ActionInfo.ViewInfo viewInfo) throws ServletException, IOException {
        try {
            SoyTemplateAddress soy = SoyTemplateAddress.address(viewInfo);
            this.soyRenderer().render(this.getAppendable(httpServletResponse), soy.getCompleteKey(), soy.getTemplateName(), this.getParameters(ar, viewInfo));
        }
        catch (SoyException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Map<String, Object> getParameters(ActionResult ar, ActionInfo.ViewInfo viewInfo) {
        HashMap parameters = Maps.newHashMap();
        parameters.putAll(this.actionViewDataSupport.getData(ar, viewInfo));
        return parameters;
    }

    @VisibleForTesting
    SoyTemplateRenderer soyRenderer() {
        SoyTemplateRendererProvider rendererProvider = (SoyTemplateRendererProvider)ComponentAccessor.getComponent(SoyTemplateRendererProvider.class);
        return rendererProvider.getRenderer();
    }

    @VisibleForTesting
    Appendable getAppendable(HttpServletResponse httpServletResponse) throws IOException {
        final PrintWriter writer = httpServletResponse.getWriter();
        return new Appendable(){

            @Override
            public Appendable append(CharSequence csq) throws IOException {
                writer.append(csq);
                return this;
            }

            @Override
            public Appendable append(CharSequence csq, int start, int end) throws IOException {
                writer.append(csq, start, end);
                return this;
            }

            @Override
            public Appendable append(char c) throws IOException {
                writer.append(c);
                return this;
            }
        };
    }
}

