/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.event.mau.MauEventService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MauEventFilter
extends AbstractHttpFilter {
    private static final String MAU_IGNORE_HEADER = "x-atlassian-mau-ignore";
    private ComponentReference<MauEventService> mauEventService = ComponentAccessor.getComponentReference(MauEventService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            Optional<String> ignoreMauEvent = Optional.ofNullable(request.getHeader(MAU_IGNORE_HEADER));
            if (!ignoreMauEvent.isPresent()) {
                this.getMauEventService().ifPresent(MauEventService::triggerEvent);
            }
        }
    }

    @VisibleForTesting
    Optional<MauEventService> getMauEventService() {
        return Optional.ofNullable(this.mauEventService.get());
    }
}

