/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalQueryProfiler {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalQueryProfiler.class);
    public static final String LUCENE_GROUP = "lucene";
    private static final ThreadLocal<ThreadLocalQueryProfiler> THREAD_LOCAL = new ThreadLocal();
    private final DataPointStore store = new DataPointStore();
    private long startTime;

    public static void start() {
        if (UtilTimerStack.isActive()) {
            ThreadLocalQueryProfiler.getProfiler().clearData();
            ThreadLocalQueryProfiler.getProfiler().begin();
        }
    }

    public static void store(String group, String query, long time) {
        if (UtilTimerStack.isActive()) {
            ThreadLocalQueryProfiler.getProfiler().storeDataPoint(group, query, time);
        }
    }

    public static void end() throws IOException {
        ThreadLocalQueryProfiler profiler = ThreadLocalQueryProfiler.getProfiler();
        if (UtilTimerStack.isActive()) {
            profiler.printData();
            profiler.clearData();
        }
    }

    private static ThreadLocalQueryProfiler getProfiler() {
        ThreadLocalQueryProfiler profiler = THREAD_LOCAL.get();
        if (profiler == null) {
            profiler = new ThreadLocalQueryProfiler();
            THREAD_LOCAL.set(profiler);
        }
        return profiler;
    }

    private ThreadLocalQueryProfiler() {
    }

    private void storeDataPoint(String group, String key, long time) {
        this.store.store(group, key, time);
    }

    private void clearData() {
        this.store.clear();
    }

    private void printData() {
        long totalRequest = System.currentTimeMillis() - this.startTime;
        long totalProfiled = 0L;
        int numDataPoints = 0;
        int numUniquePoints = 0;
        Iterator<String> iterator = this.store.getGroups().iterator();
        while (iterator.hasNext()) {
            String element;
            String groupKey = element = iterator.next();
            log.debug("RESULT GROUP: " + groupKey);
            DataPointGroup group = this.store.getGroup(groupKey);
            int numGroupPoints = 0;
            int totalGroup = 0;
            Collection<String> pointKeys = group.getPointKeys();
            for (String key : pointKeys) {
                Collection<DataPoint> points = group.getPoints(key);
                long totalTime = this.getTotalTime(points);
                totalGroup = (int)((long)totalGroup + totalTime);
                StringBuilder builder = new StringBuilder();
                builder.append("  ").append(points.size()).append(":").append(totalTime).append("ms ").append(key).append(" [");
                boolean comma = false;
                for (DataPoint point : points) {
                    ++numGroupPoints;
                    if (comma) {
                        builder.append(",");
                    } else {
                        comma = true;
                    }
                    builder.append(point.getTimeTaken());
                }
                log.debug(builder.append("]").toString());
            }
            numDataPoints += numGroupPoints;
            numUniquePoints += pointKeys.size();
            totalProfiled += (long)totalGroup;
            log.debug(groupKey + ": " + numGroupPoints + " keys (" + pointKeys.size() + " unique) took " + totalGroup + "ms/" + totalRequest + "ms : " + (float)totalGroup / (float)totalRequest * 100.0f + "% " + (pointKeys.size() > 0 ? totalGroup / pointKeys.size() + "ms/query avg." : ""));
            log.debug("");
        }
        log.debug("PROFILED : " + numDataPoints + " keys (" + numUniquePoints + " unique) took " + totalProfiled + "ms/" + totalRequest + "ms : " + (float)totalProfiled / (float)totalRequest * 100.0f + "% " + (numDataPoints > 0 ? totalProfiled / (long)numDataPoints + "ms/query avg." : ""));
    }

    private long getTotalTime(Collection<DataPoint> points) {
        long total = 0L;
        for (DataPoint element : points) {
            total += element.getTimeTaken();
        }
        return total;
    }

    private void begin() {
        this.startTime = System.currentTimeMillis();
    }

    private static class DataPointGroup {
        private final Map<String, List<DataPoint>> points = new HashMap<String, List<DataPoint>>();

        private DataPointGroup() {
        }

        public void store(DataPoint dataPoint) {
            List<DataPoint> keyPoints = this.points.get(dataPoint.getKey());
            if (keyPoints == null) {
                this.points.put(dataPoint.getKey(), CollectionBuilder.newBuilder().add((Object)dataPoint).asArrayList());
            } else {
                keyPoints.add(dataPoint);
            }
        }

        public Collection<String> getPointKeys() {
            return this.points.keySet();
        }

        public Collection<DataPoint> getPoints(String key) {
            return this.points.get(key);
        }
    }

    private static class DataPointStore {
        private final Map<String, DataPointGroup> groups = new HashMap<String, DataPointGroup>();

        private DataPointStore() {
        }

        public void clear() {
            this.groups.clear();
        }

        public void store(String group, String key, long time) {
            DataPointGroup grp = this.groups.get(group);
            if (grp == null) {
                grp = new DataPointGroup();
                this.groups.put(group, grp);
            }
            grp.store(new DataPoint(group, key, time));
        }

        public Collection<String> getGroups() {
            return this.groups.keySet();
        }

        public DataPointGroup getGroup(String groupKey) {
            return this.groups.get(groupKey);
        }
    }

    private static class DataPoint {
        private final String group;
        private final String key;
        private final long timeTaken;
        private final long timeExecuted;

        public DataPoint(String group, String query, long timeTaken) {
            this.group = group;
            this.key = query;
            this.timeTaken = timeTaken;
            this.timeExecuted = System.currentTimeMillis();
        }

        public String getGroup() {
            return this.group;
        }

        public String getKey() {
            return this.key;
        }

        public long getTimeTaken() {
            return this.timeTaken;
        }

        public long getTimeExecuted() {
            return this.timeExecuted;
        }
    }
}

