/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.ehcache.EhCacheManager;
import com.atlassian.cache.impl.jmx.MBeanRegistrar;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.fugue.Pair;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.NoopCacheEventListenerFactory;
import com.atlassian.jira.cache.CacheCompactor;
import com.atlassian.jira.cache.EhCacheCompactor;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.cache.JiraVCacheServiceCreator;
import com.atlassian.jira.cache.NullCacheCompactor;
import com.atlassian.jira.cache.slomo.SloMoCacheManager;
import com.atlassian.jira.cluster.ClusterNodeProperties;
import com.atlassian.jira.cluster.EhCacheConfigurationFactory;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.vcache.VCacheFactory;
import com.atlassian.vcache.internal.VCacheLifecycleManager;
import com.atlassian.vcache.internal.VCacheManagement;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.management.MBeanServer;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheManagerRegistrar {
    public static final String EHCACHE_CONFIGURATION = "atlassian.ehcache.config";
    public static final String ENABLE_JMX = "atlassian.cache.jmx";
    public static final String FORCE_EHCACHE = "atlassian.cache.ehcache";
    public static final String ENABLE_STATISTICS = "atlassian.cache.statistics.enabled";
    public static final String ENABLE_SLOMO = "atlassian.cache.slomo.millis";
    @VisibleForTesting
    static final ComponentContainer.Scope MANAGER_SCOPE = ComponentContainer.Scope.PROVIDED;
    static final ComponentContainer.Scope COMPACTOR_SCOPE = ComponentContainer.Scope.INTERNAL;
    @VisibleForTesting
    static final Class<CacheManager> MANAGER_KEY = CacheManager.class;
    static final Class<CacheCompactor> COMPACTOR_KEY = CacheCompactor.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManagerRegistrar.class);

    CacheManagerRegistrar() {
    }

    public static void registerCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        CacheCompactor cacheCompactor;
        MemoryCacheManager cacheManager;
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        ClusterNodeProperties clusterNodeProperties = container.getComponentInstance(ClusterNodeProperties.class);
        boolean useEhcache = CacheManagerRegistrar.useEhcache(jiraProperties, clusterNodeProperties);
        LOGGER.debug("Using Ehcache = {}", (Object)useEhcache);
        JiraSettingsDefaultsProvider defaultSettingsProvider = new JiraSettingsDefaultsProvider(jiraProperties);
        if (useEhcache) {
            net.sf.ehcache.CacheManager delegate = CacheManagerRegistrar.getCacheManagerDelegate(container, jiraProperties, clusterNodeProperties);
            cacheManager = new EhCacheManager(delegate, (CacheSettingsDefaultsProvider)defaultSettingsProvider);
            cacheCompactor = new EhCacheCompactor(delegate);
        } else {
            cacheManager = new MemoryCacheManager((CacheSettingsDefaultsProvider)defaultSettingsProvider);
            cacheCompactor = new NullCacheCompactor();
        }
        CacheManagerRegistrar.registerVCache(container, jiraProperties, (CacheManager)cacheManager, useEhcache);
        CacheManagerRegistrar.enableJmxIfNecessary(jiraProperties, (CacheManager)cacheManager, mBeanServer);
        container.instance(MANAGER_SCOPE, MANAGER_KEY, CacheManagerRegistrar.wrapForSloMo((CacheManager)cacheManager));
        container.instance(COMPACTOR_SCOPE, COMPACTOR_KEY, cacheCompactor);
    }

    private static void registerVCache(ComponentContainer container, JiraProperties jiraProperties, CacheManager cacheManager, boolean avoidCas) {
        JiraVCacheServiceCreator vCacheFactoryCreator = new JiraVCacheServiceCreator(jiraProperties, Optional.ofNullable(cacheManager), avoidCas);
        Pair<JiraVCacheRequestContextSupplier, AbstractVCacheService> pair = vCacheFactoryCreator.createVCacheService();
        container.instance(ComponentContainer.Scope.INTERNAL, JiraVCacheRequestContextSupplier.class, pair.left());
        AbstractVCacheService vCacheService = (AbstractVCacheService)pair.right();
        container.instance(ComponentContainer.Scope.INTERNAL, VCacheManagement.class, vCacheService);
        container.instance(ComponentContainer.Scope.INTERNAL, VCacheLifecycleManager.class, vCacheService);
        container.instance(ComponentContainer.Scope.PROVIDED, VCacheFactory.class, vCacheService);
    }

    public static void shutDownCacheManager(ComponentContainer container, MBeanServer mBeanServer) {
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        CacheManager cacheManager = container.getComponentInstance(MANAGER_KEY);
        if (jiraProperties.getBoolean(ENABLE_JMX).booleanValue() && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).unregisterMBeans(mBeanServer);
        }
        if (cacheManager != null) {
            cacheManager.shutdown();
        }
    }

    private static CacheManager wrapForSloMo(CacheManager delegate) {
        int delay = JiraSystemProperties.getInstance().getInteger(ENABLE_SLOMO, Integer.valueOf(0));
        return delay > 0 ? new SloMoCacheManager(delegate, delay) : delegate;
    }

    private static net.sf.ehcache.CacheManager getCacheManagerDelegate(ComponentContainer container, JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        URL configUrl = CacheManagerRegistrar.class.getResource("/ehcache.xml");
        String customEhcacheConfig = jiraProperties.getProperty(EHCACHE_CONFIGURATION);
        if (StringUtils.isNotBlank((CharSequence)customEhcacheConfig)) {
            File customEhcacheConfigFile = new File(customEhcacheConfig);
            if (customEhcacheConfigFile.isFile()) {
                try {
                    configUrl = customEhcacheConfigFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Could not create a URL from " + customEhcacheConfigFile);
                }
            } else {
                LOGGER.error(customEhcacheConfigFile + " is not a file; defaulting to JIRA's built-in Ehcache configuration");
            }
        }
        Configuration config = CacheManagerRegistrar.buildConfiguration(container, configUrl, clusterNodeProperties);
        return NoopCacheEventListenerFactory.workAroundCache95(net.sf.ehcache.CacheManager.newInstance((Configuration)config));
    }

    private static Configuration buildConfiguration(ComponentContainer container, URL configUrl, ClusterNodeProperties clusterNodeProperties) {
        EhCacheConfigurationFactory configurationFactory = container.getComponentInstance(EhCacheConfigurationFactory.class);
        return configurationFactory.newConfiguration(configUrl, clusterNodeProperties);
    }

    private static void enableJmxIfNecessary(JiraProperties jiraProperties, CacheManager cacheManager, MBeanServer mBeanServer) {
        if (jiraProperties.getBoolean(ENABLE_JMX).booleanValue() && cacheManager instanceof MBeanRegistrar) {
            ((MBeanRegistrar)cacheManager).registerMBeans(mBeanServer);
        }
    }

    private static boolean useEhcache(JiraProperties jiraProperties, ClusterNodeProperties clusterNodeProperties) {
        boolean isEhCacheForced = jiraProperties.getBoolean(FORCE_EHCACHE);
        boolean isJiraClustered = clusterNodeProperties.getNodeId() != null;
        return isEhCacheForced || isJiraClustered;
    }

    private static boolean enableStatistics(JiraProperties jiraProperties) {
        return jiraProperties.getBoolean(ENABLE_STATISTICS);
    }

    private static class JiraSettingsDefaultsProvider
    implements CacheSettingsDefaultsProvider {
        final boolean enableStatistics;

        private JiraSettingsDefaultsProvider(JiraProperties jiraProperties) {
            this.enableStatistics = CacheManagerRegistrar.enableStatistics(jiraProperties);
        }

        @Nonnull
        public CacheSettings getDefaults(@Nonnull String cacheName) {
            CacheSettingsBuilder cacheSettingsBuilder = new CacheSettingsBuilder();
            if (this.enableStatistics) {
                return cacheSettingsBuilder.statisticsEnabled().build();
            }
            return cacheSettingsBuilder.statisticsDisabled().build();
        }
    }
}

