/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.extension.ContainerProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class WrappedComponentContainer {
    private volatile ComponentContainer componentContainer;
    private volatile MutablePicoContainer wrappedContainer;

    public WrappedComponentContainer(ComponentContainer componentContainer) {
        this.componentContainer = componentContainer;
        this.wrappedContainer = componentContainer.getPicoContainer();
    }

    public MutablePicoContainer getPicoContainer() {
        return this.wrappedContainer;
    }

    public ComponentContainer getComponentContainer() {
        return this.componentContainer;
    }

    public boolean isWrapped() {
        return this.componentContainer.getPicoContainer() != this.wrappedContainer;
    }

    public void wrapWith(ContainerProvider containerProvider) {
        Preconditions.checkState((!this.isWrapped() ? 1 : 0) != 0, (Object)"Component container is already wrapped");
        this.wrappedContainer = containerProvider.getContainer((PicoContainer)this.componentContainer.getPicoContainer());
    }

    public void dispose() {
        this.removeAllComponents();
        this.wrappedContainer.dispose();
        this.wrappedContainer = null;
        this.componentContainer = null;
    }

    private void removeAllComponents() {
        ArrayList componentAdapters = Lists.newArrayList((Iterable)this.wrappedContainer.getComponentAdapters());
        for (ComponentAdapter adapter : componentAdapters) {
            this.wrappedContainer.removeComponent(adapter.getComponentKey());
        }
    }
}

