/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.component;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.ComponentAssigneeTypes;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentUtils {
    private static final Logger log = LoggerFactory.getLogger(ComponentUtils.class);

    public static boolean isProjectLeadAssignable(GenericValue entity) {
        try {
            Project project;
            if ("Component".equals(entity.getEntityName())) {
                project = ComponentUtils.getProject(entity);
            } else if ("Project".equals(entity.getEntityName())) {
                project = ComponentAccessor.getProjectFactory().getProject(entity);
            } else {
                throw new IllegalArgumentException("Entity passed must be \"Component\" or \"Project\" and NOT " + entity);
            }
            if (project != null) {
                String projectLeadUserkey = project.getLeadUserKey();
                return ComponentUtils.isUserAssignable(project, projectLeadUserkey);
            }
            return false;
        }
        catch (GenericEntityException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isProjectLeadAssignable(Project project) {
        return ComponentUtils.isUserAssignable(project, project.getLeadUserKey());
    }

    public static boolean isComponentLeadAssignable(GenericValue component) {
        Project project = ComponentUtils.getProjectFor(component);
        String componentLeadUserkey = component.getString("lead");
        return ComponentUtils.isUserAssignable(project, componentLeadUserkey);
    }

    public static long getComponentAssigneeType(GenericValue component) {
        if (component == null) {
            throw new IllegalArgumentException("Component passed can not be null.");
        }
        Long assigneeType = component.getLong("assigneetype");
        return ComponentUtils.getAssigneeType(component, assigneeType);
    }

    public static long getAssigneeType(GenericValue component, Long assigneeType) {
        if (assigneeType == null) {
            return 0L;
        }
        if (ComponentAssigneeTypes.isProjectLead(assigneeType)) {
            if (ComponentUtils.isProjectLeadAssignable(component)) {
                return 2L;
            }
            return 0L;
        }
        if (ComponentAssigneeTypes.isComponentLead(assigneeType)) {
            if (ComponentUtils.isComponentLeadAssignable(component)) {
                return 1L;
            }
            return 0L;
        }
        if (ComponentAssigneeTypes.isUnassigned(assigneeType)) {
            if (ComponentUtils.allowUnassigned()) {
                return 3L;
            }
            return 0L;
        }
        return 0L;
    }

    private static boolean allowUnassigned() {
        return ComponentAccessor.getApplicationProperties().getOption("jira.option.allowunassigned");
    }

    private static boolean isUserAssignable(Project project, String userkey) {
        if (userkey != null) {
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(userkey);
            if (user != null) {
                return ComponentAccessor.getPermissionManager().hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, user);
            }
            log.debug("User with userkey '" + userkey + "' is not assignable for project '" + project.getName() + "'! User does not exist!");
            return false;
        }
        return false;
    }

    private static Project getProject(GenericValue component) throws GenericEntityException {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        return projectManager.getProjectObj(component.getLong("project"));
    }

    private static Project getProjectFor(GenericValue component) {
        return ComponentAccessor.getProjectManager().getProjectObj(component.getLong("project"));
    }
}

