/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.host.plugin.ApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.plugin.DefaultApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.jira.application.JiraPluginApplicationMetaData;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class JiraApplicationMetaDataModuleDescriptor
extends AbstractModuleDescriptor<PluginApplicationMetaData>
implements ApplicationMetaDataModuleDescriptor {
    private final ApplicationMetaDataModuleDescriptor metadataModuleDescriptor;
    private volatile JiraPluginApplicationMetaData jiraModule;

    public JiraApplicationMetaDataModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
        this.metadataModuleDescriptor = new DefaultApplicationMetaDataModuleDescriptor(moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.metadataModuleDescriptor.init(plugin, element);
        this.jiraModule = new JiraPluginApplicationMetaData((PluginApplicationMetaData)this.metadataModuleDescriptor.getModule(), this.parseProjectTypes(element));
    }

    public JiraPluginApplicationMetaData getModule() {
        return this.jiraModule;
    }

    private List<ProjectType> parseProjectTypes(Element root) {
        ArrayList<ProjectType> projectTypes = new ArrayList<ProjectType>();
        Element projectTypesElement = root.element("projectTypes");
        if (projectTypesElement != null) {
            for (Object element : projectTypesElement.elements()) {
                projectTypes.add(this.parseProjectType((Element)element));
            }
        }
        return projectTypes;
    }

    private ProjectType parseProjectType(Element projectTypeElement) {
        ProjectTypeKey key = new ProjectTypeKey(JiraApplicationMetaDataModuleDescriptor.getRequiredElement(projectTypeElement, "key"));
        String weightString = JiraApplicationMetaDataModuleDescriptor.getRequiredElement(projectTypeElement, "weight");
        if (!StringUtils.isNumeric((CharSequence)weightString)) {
            throw new PluginParseException(String.format("Element 'weight' must have a numeric value: '%s'", weightString));
        }
        return new ProjectType(key, JiraApplicationMetaDataModuleDescriptor.getRequiredElement(projectTypeElement, "descriptionI18nKey"), JiraApplicationMetaDataModuleDescriptor.getRequiredElement(projectTypeElement, "icon"), JiraApplicationMetaDataModuleDescriptor.getRequiredElement(projectTypeElement, "color"), Integer.parseInt(weightString));
    }

    private static String getRequiredElement(Element root, String name) {
        Element element = root.element(name);
        if (element == null) {
            throw new PluginParseException(String.format("Element '%s' is required.", name));
        }
        String value = StringUtils.stripToNull((String)element.getText());
        if (value == null) {
            throw new PluginParseException(String.format("Element '%s' must have a value.", name));
        }
        return value;
    }

    public ApplicationKey getApplicationKey() {
        return this.metadataModuleDescriptor.getApplicationKey();
    }

    private static final class Elements {
        public static final String KEY = "key";
        public static final String DESC = "descriptionI18nKey";
        public static final String ICON = "icon";
        public static final String COLOR = "color";
        public static final String PROJECT_TYPES = "projectTypes";
        public static final String WEIGHT = "weight";

        private Elements() {
        }
    }
}

