/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.application.install;

import com.atlassian.fugue.Pair;
import com.atlassian.jira.application.install.ApplicationSource;
import com.atlassian.jira.application.install.BundlesVersionDiscovery;
import com.atlassian.jira.application.install.ReversibleFileOperations;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.osgi.framework.Version;

class PluginBundleInstaller {
    private static final Logger LOGGER = Logger.getLogger(PluginBundleInstaller.class);
    private final BundlesVersionDiscovery versionDiscovery;
    private final File pluginTargetFolder;
    private final Supplier<Map<String, VersionAndFile>> installedVersionsSupplier;

    public PluginBundleInstaller(File pluginTargetFolder, BundlesVersionDiscovery versionDiscovery) {
        this.versionDiscovery = versionDiscovery;
        this.pluginTargetFolder = pluginTargetFolder;
        this.installedVersionsSupplier = this.getInstalledVersionsSupplier();
    }

    public void updatePlugin(File sourceFile, ReversibleFileOperations reversibleFileOperations) throws IOException {
        File targetFile = new File(this.pluginTargetFolder, sourceFile.getName());
        this.ifSourceIsNewer(sourceFile, targetFile, previousVersionOption -> {
            try {
                if (previousVersionOption.isPresent()) {
                    reversibleFileOperations.fileDelete(((VersionAndFile)previousVersionOption.get()).targetFile);
                }
                LOGGER.info((Object)("Installing application plugin file: " + sourceFile.getAbsolutePath()));
                reversibleFileOperations.removeOnRollback(targetFile);
                Files.copy(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        });
    }

    private void ifSourceIsNewer(File sourceFile, File targetFile, Consumer<Optional<VersionAndFile>> actionIfNewer) {
        if (!targetFile.exists()) {
            Optional<BundlesVersionDiscovery.PluginIdentification> newPluginVersionOption = this.versionDiscovery.getBundleNameAndVersion(sourceFile);
            BundlesVersionDiscovery.PluginIdentification newPluginVersion = newPluginVersionOption.orElseThrow(() -> new RuntimeException("Source jar doesn't provide version information: " + sourceFile.getAbsolutePath()));
            Map installedVersions = (Map)this.installedVersionsSupplier.get();
            VersionAndFile previousVersion = (VersionAndFile)installedVersions.get(newPluginVersion.getSymbolicName());
            if (this.canReplaceOldPlugin(previousVersion, newPluginVersion)) {
                actionIfNewer.accept(Optional.ofNullable(previousVersion));
            } else {
                LOGGER.trace((Object)("File skipped (newer or equal version exists): " + sourceFile.getAbsolutePath()));
            }
        } else {
            LOGGER.trace((Object)("File skipped (filename exists): " + sourceFile.getAbsolutePath()));
        }
    }

    private boolean canReplaceOldPlugin(@Nullable VersionAndFile previousVersion, BundlesVersionDiscovery.PluginIdentification newVersion) {
        return null == previousVersion || previousVersion.version.compareTo(newVersion.getVersion()) < 0;
    }

    private Supplier<Map<String, VersionAndFile>> getInstalledVersionsSupplier() {
        return Suppliers.memoize(this::getInstalledPluginVersions);
    }

    private Map<String, VersionAndFile> getInstalledPluginVersions() {
        Object[] installedPluginFiles = this.pluginTargetFolder.listFiles(ApplicationSource::jarsOnly);
        if (ArrayUtils.isNotEmpty((Object[])installedPluginFiles)) {
            return Arrays.stream(installedPluginFiles).map(file -> this.versionDiscovery.getBundleNameAndVersion((File)file).map(version -> new Pair(file, version))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(fileAndVersion -> ((BundlesVersionDiscovery.PluginIdentification)fileAndVersion.right()).getSymbolicName(), fileAndVersion -> new VersionAndFile(((BundlesVersionDiscovery.PluginIdentification)fileAndVersion.right()).getVersion(), (File)fileAndVersion.left()), PluginBundleInstaller::useNewestVersion));
        }
        return ImmutableMap.of();
    }

    private static VersionAndFile useNewestVersion(VersionAndFile left, VersionAndFile right) {
        return left.version.compareTo(right.version) < 0 ? right : left;
    }

    private static class VersionAndFile {
        Version version;
        File targetFile;

        public VersionAndFile(Version version, File targetFile) {
            this.version = version;
            this.targetFile = targetFile;
        }
    }
}

