/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.avatar;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarFilenames;
import com.atlassian.jira.avatar.AvatarTagger;
import com.atlassian.jira.config.util.JiraHome;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.FilenameUtils;

public class AvatarTaggerImpl
implements AvatarTagger {
    public static final String FORMAT_NAME = "javax_imageio_png_1.0";
    private static final String AVATAR_DIRECTORY = "data/avatars";
    private static final String TAGGED_AVATAR_FILE_SUFFIX = "jrvtg.png";
    private final JiraHome jiraHome;

    public AvatarTaggerImpl(JiraHome jiraHome) {
        this.jiraHome = jiraHome;
    }

    @Override
    public String tagAvatar(long id, String filename) throws IOException {
        File base = this.getAvatarBaseDirectory();
        for (Avatar.Size size : Avatar.Size.values()) {
            File avatarFileInstance = new File(base, AvatarFilenames.getAvatarFilename(id, filename, size));
            if (!avatarFileInstance.exists()) continue;
            this.tagSingleAvatarFile(avatarFileInstance, new File(AvatarTaggerImpl.toTaggedName(avatarFileInstance.getAbsolutePath())));
        }
        try {
            for (Avatar.Size size : Avatar.Size.values()) {
                File oldAvatarFile = new File(base, AvatarFilenames.getAvatarFilename(id, filename, size));
                if (!oldAvatarFile.exists()) continue;
                oldAvatarFile.delete();
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return AvatarTaggerImpl.toTaggedName(filename);
    }

    @Override
    public void tagSingleAvatarFile(File source, File destination) throws IOException {
        BufferedImage in = ImageIO.read(source);
        FileImageOutputStream outputStream = new FileImageOutputStream(destination);
        this.write(in, outputStream);
    }

    @Override
    public void tag(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedImage in = ImageIO.read(ImageIO.createImageInputStream(inputStream));
        ImageOutputStream out = ImageIO.createImageOutputStream(outputStream);
        this.write(in, out);
    }

    @Override
    public void saveTaggedAvatar(RenderedImage in, String format, OutputStream targetStream) throws IOException {
        try {
            this.write(in, new MemoryCacheImageOutputStream(targetStream), format);
        }
        catch (NoSuchElementException x) {
            throw new IllegalArgumentException("format: '" + format + "'");
        }
    }

    @Override
    public void saveTaggedAvatar(RenderedImage in, String name, File file) throws IOException {
        try (FileImageOutputStream stream = new FileImageOutputStream(file);){
            this.write(in, stream);
        }
    }

    private void write(RenderedImage in, Object output) throws IOException {
        this.write(in, output, "png");
    }

    private void write(RenderedImage in, Object output, String format) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        IIOMetadata metadata = AvatarTaggerImpl.metadata(writer, writeParam);
        writer.setOutput(output);
        writer.write(metadata, new IIOImage(in, null, metadata), writeParam);
    }

    private File getAvatarBaseDirectory() {
        return new File(this.jiraHome.getHome(), AVATAR_DIRECTORY);
    }

    private static String toTaggedName(String filename) {
        return FilenameUtils.removeExtension((String)filename) + TAGGED_AVATAR_FILE_SUFFIX;
    }

    private static IIOMetadata metadata(ImageWriter writer, ImageWriteParam writeParam) throws IIOInvalidTreeException {
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode root = new IIOMetadataNode(FORMAT_NAME);
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
        textEntry.setAttribute("keyword", "jira-system-image-type");
        textEntry.setAttribute("value", "avatar");
        textEntry.setAttribute("encoding", "UTF-8");
        textEntry.setAttribute("language", "EN");
        textEntry.setAttribute("compression", "none");
        text.appendChild(textEntry);
        root.appendChild(text);
        metadata.mergeTree(FORMAT_NAME, root);
        return metadata;
    }
}

