/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.group;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.bc.group.GroupRelationshipChecker;
import com.atlassian.jira.bc.group.GroupsToApplicationsSeatingHelper;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class GroupAccessLabelsManager {
    private final GroupsToApplicationsSeatingHelper seatingHelper;
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupRelationshipChecker relationshipChecker;

    public GroupAccessLabelsManager(GroupsToApplicationsSeatingHelper seatingHelper, GlobalPermissionManager globalPermissionManager, GroupRelationshipChecker relationshipChecker) {
        this.seatingHelper = seatingHelper;
        this.globalPermissionManager = globalPermissionManager;
        this.relationshipChecker = relationshipChecker;
    }

    public GroupAccessLabels getForGroup(Group group, Optional<Long> directoryId) {
        Set<ApplicationRole> applications = this.seatingHelper.findEffectiveApplicationsByGroups(directoryId, (Set<String>)ImmutableSet.of((Object)group.getName()));
        return new GroupAccessLabels(this.isGroupAdminGroup(group, directoryId), applications);
    }

    private boolean isGroupAdminGroup(Group group, Optional<Long> directoryId) {
        Collection adminGroups = this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER);
        Collection sysadminGroups = this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN);
        Set groups = (Set)Stream.concat(adminGroups.stream(), sysadminGroups.stream()).collect(CollectorsUtil.toImmutableSet());
        return groups.stream().map(Group::getName).anyMatch(adminGroup -> this.relationshipChecker.isGroupEqualOrNested(directoryId, group.getName(), (String)adminGroup));
    }

    public static class GroupAccessLabels {
        private final boolean isAdmin;
        private final Set<ApplicationRole> accessibleApplications;

        public GroupAccessLabels(boolean isAdmin, Set<ApplicationRole> accessibleApplications) {
            this.isAdmin = isAdmin;
            this.accessibleApplications = accessibleApplications;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public Set<ApplicationRole> getAccessibleApplications() {
            return this.accessibleApplications;
        }
    }
}

