/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardCreationData;
import com.atlassian.jira.board.BoardId;
import com.atlassian.jira.board.BoardManager;
import com.atlassian.jira.board.BoardService;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public class BoardServiceImpl
implements BoardService {
    private static final String NO_CREATE_SHARED_OBJECTS_PERMISSION = "core.board.service.error.no.create.shared.permission";
    private static final String NO_VIEW_AT_LEAST_ONE_PROJECT_PERMISSION = "core.board.service.error.no.view.board.permission";
    private static final String NO_BOARD_FOUND_FOR_ID = "core.board.service.error.no.board.found.for.id";
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final BoardManager boardManager;
    private final SearchService searchService;
    private final ProjectService projectService;

    public BoardServiceImpl(BoardManager boardManager, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18nFactory, SearchService searchService, ProjectService projectService, PermissionManager permissionManager) {
        this.boardManager = boardManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18nFactory = i18nFactory;
        this.searchService = searchService;
        this.projectService = projectService;
        this.permissionManager = permissionManager;
    }

    public ServiceOutcome<Board> createDefaultBoardForProject(ApplicationUser user, long projectId) {
        ServiceOutcome permissionResult = this.checkProjectPermission(user, projectId, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!permissionResult.isValid()) {
            return permissionResult;
        }
        BoardCreationData boardCreationData = new BoardCreationData.Builder().jql(this.getJql(projectId)).projectId(projectId).build();
        ErrorCollection jqlParseResult = this.parseJql(user, boardCreationData);
        if (jqlParseResult.hasAnyErrors()) {
            return new ServiceOutcomeImpl<Board>(jqlParseResult);
        }
        return ServiceOutcomeImpl.ok(this.boardManager.createBoard(boardCreationData));
    }

    public ServiceOutcome<Board> createBoard(ApplicationUser user, @Nonnull BoardCreationData boardCreationData) {
        if (!this.hasCreateSharedObjectsPermission(user)) {
            return new ServiceOutcomeImpl<Board>(ErrorCollections.create((String)this.i18n(user).getText(NO_CREATE_SHARED_OBJECTS_PERMISSION), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
        }
        ErrorCollection jqlValidateResult = this.parseAndValidateJql(user, boardCreationData);
        if (jqlValidateResult.hasAnyErrors()) {
            return new ServiceOutcomeImpl<Board>(jqlValidateResult);
        }
        return ServiceOutcomeImpl.ok(this.boardManager.createBoard(boardCreationData));
    }

    public ServiceOutcome<List<Board>> getBoardsForProject(ApplicationUser user, long projectId) {
        ServiceOutcome permissionResult = this.checkProjectPermission(user, projectId, ProjectAction.VIEW_PROJECT);
        if (!permissionResult.isValid()) {
            return permissionResult;
        }
        return ServiceOutcomeImpl.ok(this.boardManager.getBoardsForProject(projectId));
    }

    public ServiceOutcome<Boolean> hasBoardInProject(ApplicationUser user, long projectId) {
        ServiceOutcome permissionResult = this.checkProjectPermission(user, projectId, ProjectAction.VIEW_PROJECT);
        if (!permissionResult.isValid()) {
            return ServiceOutcomeImpl.error(permissionResult);
        }
        return ServiceOutcomeImpl.ok(this.boardManager.hasBoardForProject(projectId));
    }

    public ServiceOutcome<Board> getBoard(ApplicationUser user, @Nonnull BoardId boardId) {
        if (!this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user)) {
            return new ServiceOutcomeImpl<Board>(ErrorCollections.create((String)this.i18n(user).getText(NO_VIEW_AT_LEAST_ONE_PROJECT_PERMISSION), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
        }
        Optional<Board> boardOptional = this.boardManager.getBoard(boardId);
        return boardOptional.map(board -> ServiceOutcomeImpl.ok(board)).orElse(ServiceOutcomeImpl.error(this.i18n(user).getText(NO_BOARD_FOUND_FOR_ID, (Object)boardId.getId()), ErrorCollection.Reason.NOT_FOUND));
    }

    public ServiceOutcome<Boolean> deleteBoard(ApplicationUser user, @Nonnull BoardId boardId) {
        if (!this.hasCreateSharedObjectsPermission(user)) {
            ErrorCollection error = ErrorCollections.create((String)this.i18n(user).getText(NO_CREATE_SHARED_OBJECTS_PERMISSION), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN);
            return new ServiceOutcomeImpl<Boolean>(error);
        }
        return ServiceOutcomeImpl.ok(this.boardManager.deleteBoard(boardId));
    }

    private ErrorCollection parseJql(ApplicationUser user, BoardCreationData boardCreationData) {
        SearchService.ParseResult queryParseResult = this.searchService.parseQuery(user, boardCreationData.getJql());
        if (!queryParseResult.isValid()) {
            return this.errorCollection(queryParseResult.getErrors().getErrorMessages());
        }
        return new SimpleErrorCollection();
    }

    private ErrorCollection parseAndValidateJql(ApplicationUser user, BoardCreationData boardCreationData) {
        SearchService.ParseResult queryParseResult = this.searchService.parseQuery(user, boardCreationData.getJql());
        if (!queryParseResult.isValid()) {
            return this.errorCollection(queryParseResult.getErrors().getErrorMessages());
        }
        MessageSet validateResult = this.searchService.validateQuery(user, queryParseResult.getQuery());
        if (validateResult.hasAnyErrors()) {
            return this.errorCollection(validateResult.getErrorMessages());
        }
        return new SimpleErrorCollection();
    }

    private ServiceOutcome checkProjectPermission(ApplicationUser user, long projectId, ProjectAction projectAction) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByIdForAction(user, Long.valueOf(projectId), projectAction);
        if (getProjectResult.isValid()) {
            return new ServiceOutcomeImpl((ErrorCollection)new SimpleErrorCollection());
        }
        return new ServiceOutcomeImpl(getProjectResult.getErrorCollection());
    }

    private String getJql(long projectId) {
        return this.searchService.getJqlString(JqlQueryBuilder.newBuilder().where().project(new Long[]{projectId}).buildQuery());
    }

    private ErrorCollection errorCollection(Collection<String> messages) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessages(messages);
        return errorCollection;
    }

    private boolean hasCreateSharedObjectsPermission(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.CREATE_SHARED_OBJECTS, user);
    }

    private I18nHelper i18n(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }
}

