/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.board;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.board.Board;
import com.atlassian.jira.board.BoardDataService;
import com.atlassian.jira.board.BoardWorkflowService;
import com.atlassian.jira.board.model.BoardColumn;
import com.atlassian.jira.board.model.BoardData;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.issue.IssueSearchLimits;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DefaultBoardDataService
implements BoardDataService {
    static final String JQL_PARSE_ERROR = "core.board.data.service.jql.parse.error";
    static final String SEARCH_ERROR = "core.board.data.service.search.error";
    private final BoardWorkflowService boardWorkflowService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final IssueSearchLimits issueSearchLimits;
    private final SearchService searchService;

    public DefaultBoardDataService(BoardWorkflowService boardWorkflowService, I18nHelper.BeanFactory i18nFactory, IssueSearchLimits issueSearchLimits, SearchService searchService) {
        this.boardWorkflowService = boardWorkflowService;
        this.i18nFactory = i18nFactory;
        this.issueSearchLimits = issueSearchLimits;
        this.searchService = searchService;
    }

    public ServiceOutcome<BoardData> getDataForBoard(ApplicationUser user, Board board) {
        Optional<Query> queryOptional = this.getQueryForJql(user, board.getJql());
        return queryOptional.map(query -> this.boardDataOrError(board, user, (Query)query)).orElse(ServiceOutcomeImpl.error(this.translatedTextForUser(JQL_PARSE_ERROR, user), ErrorCollection.Reason.VALIDATION_FAILED));
    }

    private Optional<Query> getQueryForJql(ApplicationUser user, String jql) {
        SearchService.ParseResult jqlParseResult = this.searchService.parseQuery(user, jql);
        return Optional.ofNullable(jqlParseResult.getQuery());
    }

    private ServiceOutcome<BoardData> boardDataOrError(Board board, ApplicationUser user, Query query) {
        try {
            return ServiceOutcomeImpl.ok(this.getBoardDataGivenQuery(board, user, query));
        }
        catch (SearchException searchException) {
            return ServiceOutcomeImpl.error(this.translatedTextForUser(SEARCH_ERROR, user), ErrorCollection.Reason.SERVER_ERROR);
        }
    }

    private BoardData getBoardDataGivenQuery(Board board, ApplicationUser user, Query query) throws SearchException {
        SearchResults searchResults = this.doSearchGivenQuery(user, query);
        List<Issue> issues = this.getIssuesFromSearchResults(searchResults);
        List<Status> statuses = this.getStatusesForQuery(user, query);
        List<ApplicationUser> assignees = this.getAssigneesFromSearchResults(searchResults);
        List<BoardColumn> columns = this.getColumns(user, query);
        return new BoardData.Builder().board(board).jql(board.getJql()).id(board.getId()).issues(issues).statuses(statuses).people(assignees).columns(columns).maxResults(issues.size()).total(searchResults.getTotal()).build();
    }

    private SearchResults doSearchGivenQuery(ApplicationUser user, Query query) throws SearchException {
        return this.searchService.search(user, query, new PagerFilter(this.issueSearchLimits.getMaxResults()));
    }

    private List<Issue> getIssuesFromSearchResults(SearchResults results) {
        return results.getIssues();
    }

    private List<ApplicationUser> getAssigneesFromSearchResults(SearchResults results) {
        return (List)this.getIssuesFromSearchResults(results).stream().map(Issue::getAssignee).distinct().filter(Objects::nonNull).collect(CollectorsUtil.toImmutableList());
    }

    private List<Status> getStatusesForQuery(ApplicationUser user, Query query) {
        return (List)this.boardWorkflowService.getAccessibleStatuses(user, query).stream().collect(CollectorsUtil.toImmutableList());
    }

    private List<BoardColumn> getColumns(ApplicationUser user, Query query) {
        Set initialStatuses = this.boardWorkflowService.getInitialStatusesForQuery(user, query);
        ImmutableList allStatusesSorted = Ordering.from(this.byInitialStatus(initialStatuses)).compound(this.byStatusCategory()).compound(this.byStatusId()).immutableSortedCopy(this.getStatusesForQuery(user, query));
        return (List)allStatusesSorted.stream().map(status -> new BoardColumn(status, (List)ImmutableList.of((Object)status))).collect(CollectorsUtil.toImmutableList());
    }

    private Comparator<Status> byInitialStatus(Set<Status> initialStatuses) {
        return (thisStatus, otherStatus) -> {
            boolean neitherInitial;
            boolean bothInitial = initialStatuses.contains(thisStatus) && initialStatuses.contains(otherStatus);
            boolean bl = neitherInitial = !initialStatuses.contains(thisStatus) && !initialStatuses.contains(otherStatus);
            if (bothInitial || neitherInitial) {
                return 0;
            }
            if (initialStatuses.contains(thisStatus)) {
                return -1;
            }
            return 1;
        };
    }

    private Comparator<Status> byStatusCategory() {
        return (thisStatus, otherStatus) -> thisStatus.getStatusCategory().compareTo((Object)otherStatus.getStatusCategory());
    }

    private Comparator<Status> byStatusId() {
        return (thisStatus, otherStatus) -> Long.valueOf(thisStatus.getId()).compareTo(Long.valueOf(otherStatus.getId()));
    }

    private String translatedTextForUser(String i18nKey, ApplicationUser user) {
        return this.i18nFactory.getInstance(user).getText(i18nKey);
    }
}

