/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.fugue.Option;
import com.atlassian.jira.cache.JiraVCacheRequestContextSupplier;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.tenancy.JiraTenantContext;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.vcache.internal.VCacheLifecycleManager;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class JiraVCacheInitialisationUtils {
    private static final Logger log = LoggerFactory.getLogger(JiraVCacheInitialisationUtils.class);

    private JiraVCacheInitialisationUtils() {
    }

    public static boolean initVCache() {
        Optional tenantContext = ComponentAccessor.getComponentSafely(TenantContext.class);
        if (tenantContext.isPresent()) {
            ((JiraTenantContext)tenantContext.get()).setCurrentTenant((Tenant)JiraVCacheInitialisationUtils.getFakeTenant());
            JiraTenantImpl currentTenant = (JiraTenantImpl)((TenantContext)tenantContext.get()).getCurrentTenant();
            if (currentTenant != null) {
                return JiraVCacheInitialisationUtils.initVCache(currentTenant);
            }
            log.debug("Unable to initialize VCache request context supplier - cannot determine current tenant.");
        } else {
            log.debug("Unable to initialize VCache request context supplier - cannot get components from the container.");
        }
        return false;
    }

    public static boolean initVCache(JiraTenantImpl currentTenant) {
        Optional requestContextSupplier = ComponentAccessor.getComponentSafely(JiraVCacheRequestContextSupplier.class);
        if (requestContextSupplier.isPresent()) {
            if (((JiraVCacheRequestContextSupplier)requestContextSupplier.get()).isInitilised()) {
                return false;
            }
            ((JiraVCacheRequestContextSupplier)requestContextSupplier.get()).initThread(currentTenant.getId());
            return true;
        }
        log.debug("Unable to initialize VCache request context supplier - cannot get components from the container.");
        return false;
    }

    public static void cleanupVCache() {
        JiraVCacheRequestContextSupplier requestContextSupplier = ComponentAccessor.getComponentSafely(JiraVCacheRequestContextSupplier.class).orElse(null);
        if (requestContextSupplier != null && requestContextSupplier.isInitilised()) {
            try {
                Option.option((Object)ComponentAccessor.getComponent(VCacheLifecycleManager.class)).forEach(service -> service.transactionSync(requestContextSupplier.get()));
            }
            catch (IllegalStateException e) {
                log.warn("Error while cleaning up vcache.", (Throwable)e);
            }
            finally {
                requestContextSupplier.clearThread();
            }
        }
    }

    public static JiraTenantImpl getFakeTenant() {
        return new JiraTenantImpl("fakeTenantId");
    }
}

