/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cache;

import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;
import com.atlassian.instrumentation.ExternalCounter;
import com.atlassian.instrumentation.ExternalGauge;
import com.atlassian.instrumentation.ExternalValue;
import com.atlassian.instrumentation.Instrument;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ManagedCacheInstruments {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedCacheInstruments.class);
    private static final IgnoreHeapSize IGNORE_HEAP_SIZE = new IgnoreHeapSize();
    private final ManagedCache managedCache;
    private final String name;

    public ManagedCacheInstruments(ManagedCache managedCache) {
        this.managedCache = (ManagedCache)Assertions.notNull((String)"managedCache", (Object)managedCache);
        this.name = managedCache.getName();
    }

    @Nonnull
    public List<Instrument> getInstruments() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.getStatistics(), entry -> this.toInstrument((CacheStatisticsKey)entry.getKey(), (Supplier<Long>)((Supplier)entry.getValue()))));
    }

    private Instrument toInstrument(CacheStatisticsKey key, Supplier<Long> supplier) {
        switch (key.getType()) {
            case COUNTER: {
                return this.counter(key, supplier);
            }
        }
        return this.gauge(key, supplier);
    }

    private Iterable<Map.Entry<CacheStatisticsKey, Supplier<Long>>> getStatistics() {
        if (LOG.isDebugEnabled()) {
            return this.managedCache.getStatistics().entrySet();
        }
        return Iterables.filter(this.managedCache.getStatistics().entrySet(), (Predicate)IGNORE_HEAP_SIZE);
    }

    public String getName() {
        return this.name;
    }

    private ExternalCounter counter(CacheStatisticsKey key, Supplier<Long> supplier) {
        return new ExternalCounter(this.name + '.' + key.getLabel(), (ExternalValue)new StatisticValue(supplier));
    }

    private ExternalGauge gauge(CacheStatisticsKey key, Supplier<Long> supplier) {
        return new ExternalGauge(this.name + '.' + key.getLabel(), (ExternalValue)new StatisticValue(supplier));
    }

    static class StatisticValue
    implements ExternalValue {
        private final Supplier<Long> supplier;

        StatisticValue(Supplier<Long> supplier) {
            this.supplier = supplier;
        }

        public long getValue() {
            Long value = (Long)this.supplier.get();
            return value != null ? value : 0L;
        }
    }

    static class IgnoreHeapSize
    implements Predicate<Map.Entry<CacheStatisticsKey, Supplier<Long>>> {
        IgnoreHeapSize() {
        }

        public boolean apply(Map.Entry<CacheStatisticsKey, Supplier<Long>> entry) {
            return entry.getKey() != CacheStatisticsKey.HEAP_SIZE;
        }
    }
}

