/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.beehive.db.ClusterNodeHeartbeatService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterServicesRegistry;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.NodeReindexService;
import com.atlassian.jira.license.ClusterLicenseCheck;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;

public class DefaultClusterManager
implements ClusterManager,
Startable {
    private final ClusterServicesRegistry clusterServicesRegistry;
    private final NodeStateManager nodeStateManager;
    private final EventPublisher eventPublisher;
    private final ClusterLicenseCheck licenseCheck;
    private Collection<Node> liveNodes;
    @ClusterSafe(value="This reference is loaded like this to avoid cyclic dependency")
    private final ComponentReference<ClusterNodeHeartbeatService> heartbeatServiceRef = ComponentAccessor.getComponentReference(ClusterNodeHeartbeatService.class);

    public DefaultClusterManager(ClusterServicesRegistry clusterServicesRegistry, NodeStateManager nodeStateManager, EventPublisher eventPublisher, ClusterLicenseCheck licenseCheck) {
        this.clusterServicesRegistry = clusterServicesRegistry;
        this.nodeStateManager = nodeStateManager;
        this.eventPublisher = eventPublisher;
        this.licenseCheck = licenseCheck;
    }

    public void start() {
        this.eventPublisher.register((Object)this);
    }

    @Nullable
    public String getNodeId() {
        return this.nodeStateManager.getNode().getNodeId();
    }

    public boolean isClustered() {
        return this.nodeStateManager.getNode().isClustered();
    }

    @Override
    public Set<Node> getAllNodes() {
        return this.isClustered() ? this.nodeStateManager.getAllNodes() : ImmutableSet.of();
    }

    @Override
    public boolean isActive() {
        return this.nodeStateManager.getNode().getState().equals((Object)Node.NodeState.ACTIVE);
    }

    @Override
    public void checkIndex() {
        NodeReindexService nodeReindexService = this.clusterServicesRegistry.getNodeReindexService();
        if (!nodeReindexService.canIndexBeRebuilt()) {
            this.requestCurrentIndexFromNode("ANY");
        }
    }

    @Override
    public void requestCurrentIndexFromNode(String node) {
        NodeReindexService nodeReindexService = this.clusterServicesRegistry.getNodeReindexService();
        nodeReindexService.pause();
        nodeReindexService.resetIndexCount();
        this.clusterServicesRegistry.getMessageHandlerService().sendMessage(node, new Message("Backup Index", null));
    }

    @Override
    public Collection<Node> findLiveNodes() {
        if (this.liveNodes == null) {
            this.refreshLiveNodes();
        }
        return this.liveNodes;
    }

    @Override
    public void refreshLiveNodes() {
        final Collection heartbeatLiveNodesIds = ((ClusterNodeHeartbeatService)this.heartbeatServiceRef.get()).findLiveNodes();
        Collection filter = CollectionUtil.filter(this.getAllNodes(), (Predicate)new Predicate<Node>(){

            public boolean evaluate(Node node) {
                return node != null && node.getState() == Node.NodeState.ACTIVE && heartbeatLiveNodesIds.contains(node.getNodeId());
            }
        });
        this.liveNodes = ImmutableSet.copyOf((Collection)filter);
    }

    @EventListener
    public void releaseNodeReindexService(IndexesRestoredEvent ev) {
        NodeReindexService nodeReindexService = this.clusterServicesRegistry.getNodeReindexService();
        nodeReindexService.start();
        nodeReindexService.replayLocalOperations();
    }

    @Override
    public boolean isClusterLicensed() {
        return this.licenseCheck.evaluate().isPass();
    }
}

