/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.group;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.ImmutableGroup;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import org.picocontainer.PicoContainer;

public class GroupConfigurationIdentifier {
    private final Supplier<PicoContainer> picoContainerSupplier;

    public GroupConfigurationIdentifier() {
        this.picoContainerSupplier = () -> ComponentManager.getInstance().getContainer();
    }

    @VisibleForTesting
    GroupConfigurationIdentifier(PicoContainer container) {
        this.picoContainerSupplier = () -> container;
    }

    private Set<GroupConfigurable> getGroupConfigurableComponents() {
        return Sets.newHashSet((Iterable)((PicoContainer)this.picoContainerSupplier.get()).getComponents(GroupConfigurable.class));
    }

    public boolean groupHasExistingConfiguration(@Nonnull String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        ImmutableGroup group = new ImmutableGroup(groupName);
        return this.getGroupConfigurableComponents().stream().anyMatch(groupConfigurable -> groupConfigurable.isGroupUsed((Group)group));
    }
}

