/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.MembershipKey;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.UserOrGroupStub;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.util.cache.WeakInterner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizInternalMembershipDao
implements InternalMembershipDao {
    private static final Logger LOG = LoggerFactory.getLogger(OfBizInternalMembershipDao.class);
    private static final ImmutableList<String> FIELD_LIST_LOWERCHILDNAME = ImmutableList.of((Object)"lowerChildName");
    private static final ImmutableList<String> FIELD_LIST_CHILDNAME = ImmutableList.of((Object)"childName");
    private static final ImmutableList<String> FIELD_LIST_LOWERPARENTNAME = ImmutableList.of((Object)"lowerParentName");
    private final OfBizDelegator ofBizDelegator;
    private WeakInterner<String> myInterner = WeakInterner.newWeakInterner();
    private final Cache<MembershipKey, Set<String>> parentsCache;
    private final Cache<MembershipKey, Set<String>> childrenCache;

    public OfBizInternalMembershipDao(OfBizDelegator ofBizDelegator, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.parentsCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".parentsCache", (CacheLoader)new ParentsLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
        this.childrenCache = cacheManager.getCache(OfBizInternalMembershipDao.class.getName() + ".childrenCache", (CacheLoader)new ChildrenLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
    }

    @Override
    public boolean isUserDirectMember(long directoryId, String userName, String groupName) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_USER, groupName, userName);
    }

    @Override
    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
    }

    private boolean isDirectMember(long directoryId, MembershipType membershipType, String parentName, String childName) {
        Set parents = (Set)this.parentsCache.get((Object)MembershipKey.getKey(directoryId, childName, membershipType));
        return parents.contains(parentName) || parents.contains(IdentifierUtils.toLowerCase((String)parentName));
    }

    @Override
    public void addUserToGroup(long directoryId, UserOrGroupStub user, UserOrGroupStub group) throws MembershipAlreadyExistsException {
        if (this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
            throw new MembershipAlreadyExistsException(directoryId, user.getName(), group.getName());
        }
        try {
            this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
        }
        catch (DataAccessException e) {
            if (this.isDirectMember(directoryId, MembershipType.GROUP_USER, group.getName(), user.getName())) {
                throw new MembershipAlreadyExistsException(directoryId, user.getName(), group.getName());
            }
            throw e;
        }
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    @Override
    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<UserOrGroupStub> users, UserOrGroupStub group) {
        List<String> currentUsers = this.getChildrenOfGroupFromCache(directoryId, group.getName(), MembershipType.GROUP_USER);
        BatchResult result = new BatchResult(users.size());
        boolean groupIsDirty = false;
        for (UserOrGroupStub user : users) {
            try {
                if (currentUsers.contains(user.getName())) {
                    result.addFailure((Object)user.getName());
                } else {
                    this.createMembership(directoryId, MembershipType.GROUP_USER, group, user);
                    this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
                    groupIsDirty = true;
                }
                result.addSuccess((Object)user.getName());
            }
            catch (DataAccessException e) {
                result.addFailure((Object)user.getName());
            }
        }
        if (groupIsDirty) {
            this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        }
        return result;
    }

    private void createMembership(long directoryId, MembershipType membershipType, UserOrGroupStub parent, UserOrGroupStub child) {
        this.ofBizDelegator.createValue("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("childName", child.getName()).put("lowerChildName", child.getLowerName()).put("parentId", parent.getId()).put("parentName", parent.getName()).put("lowerParentName", parent.getLowerName()).put("membershipType", membershipType.name()).build());
    }

    @Override
    public void addGroupToGroup(long directoryId, UserOrGroupStub child, UserOrGroupStub parent) {
        if (!this.isDirectMember(directoryId, MembershipType.GROUP_GROUP, parent.getName(), child.getName())) {
            this.createMembership(directoryId, MembershipType.GROUP_GROUP, parent, child);
            this.invalidateChildrenCacheEntry(directoryId, parent.getName(), MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, child.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public void removeUserFromGroup(long directoryId, UserOrGroupStub user, UserOrGroupStub group) throws MembershipNotFoundException {
        this.removeMembership(directoryId, MembershipType.GROUP_USER, group, user);
        this.invalidateChildrenCacheEntry(directoryId, group.getName(), MembershipType.GROUP_USER);
        this.invalidateParentsCacheEntry(directoryId, user.getName(), MembershipType.GROUP_USER);
    }

    private void removeMembership(long directoryId, MembershipType membershipType, UserOrGroupStub parent, UserOrGroupStub child) throws MembershipNotFoundException {
        GenericValue membershipGenericValue = EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("childId", child.getId()).put("parentId", parent.getId()).put("membershipType", membershipType.name()).build()));
        if (membershipGenericValue == null) {
            throw new MembershipNotFoundException(child.getName(), parent.getName());
        }
        this.ofBizDelegator.removeValue(membershipGenericValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroupFromGroup(long directoryId, UserOrGroupStub childGroup, UserOrGroupStub parentGroup) throws MembershipNotFoundException {
        try {
            this.removeMembership(directoryId, MembershipType.GROUP_GROUP, parentGroup, childGroup);
        }
        finally {
            this.invalidateChildrenCacheEntry(directoryId, parentGroup.getName(), MembershipType.GROUP_GROUP);
            this.invalidateParentsCacheEntry(directoryId, childGroup.getName(), MembershipType.GROUP_GROUP);
        }
    }

    @Override
    public long countDirectMembersOfGroup(long directoryId, String groupName, MembershipType type) {
        return Select.from("Membership").whereEqual("directoryId", directoryId).andEqual("lowerParentName", IdentifierUtils.toLowerCase((String)groupName)).andEqual("membershipType", type.name()).runWith(this.ofBizDelegator).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMembersFromGroup(Group group) {
        List<String> users = this.getChildrenOfGroupFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_USER);
        List<String> childGroups = this.getChildrenOfGroupFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("parentName", group.getName()).build());
        }
        finally {
            for (String userName : users) {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_USER);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), userName, MembershipType.GROUP_USER);
            }
            for (String childName : childGroups) {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), childName, MembershipType.GROUP_GROUP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllGroupMemberships(Group group) {
        List<String> parentGroups = this.getParentsForMemberFromCache(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", group.getDirectoryId()).put("membershipType", MembershipType.GROUP_GROUP.name()).put("childName", group.getName()).build());
        }
        finally {
            for (String parentName : parentGroups) {
                this.invalidateChildrenCacheEntry(group.getDirectoryId(), parentName, MembershipType.GROUP_GROUP);
                this.invalidateParentsCacheEntry(group.getDirectoryId(), group.getName(), MembershipType.GROUP_GROUP);
            }
        }
    }

    @Override
    public void removeAllUserMemberships(User user) {
        this.removeAllUserMemberships(user.getDirectoryId(), user.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllUserMemberships(long directoryId, String username) {
        List<String> groups = this.getParentsForMemberFromCache(directoryId, username, MembershipType.GROUP_USER);
        try {
            this.ofBizDelegator.removeByAnd("Membership", PrimitiveMap.builder().put("directoryId", directoryId).put("membershipType", MembershipType.GROUP_USER.name()).put("childName", username).build());
        }
        finally {
            for (String groupName : groups) {
                this.invalidateChildrenCacheEntry(directoryId, groupName, MembershipType.GROUP_USER);
                this.invalidateParentsCacheEntry(directoryId, username, MembershipType.GROUP_USER);
            }
        }
    }

    public Set<String> findGroupChildrenOfGroups(long directoryId, Collection<String> groupNames) {
        return this.findChildrenOfGroupsGeneric(directoryId, groupNames, MembershipType.GROUP_GROUP);
    }

    public Set<String> findUserChildrenOfGroups(long directoryId, Collection<String> groupNames) {
        return this.findChildrenOfGroupsGeneric(directoryId, groupNames, MembershipType.GROUP_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findChildrenOfGroupsGeneric(long directoryId, Collection<String> groupNames, MembershipType relationship) {
        if (groupNames.isEmpty()) {
            return Collections.emptySet();
        }
        List adjustedGroupNames = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList());
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr parentCondition = new EntityExpr("lowerParentName", EntityOperator.IN, adjustedGroupNames);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)relationship.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)parentCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_CHILDNAME, null, null);){
            HashSet<String> children = new HashSet<String>();
            GenericValue membership = memberships.next();
            while (membership != null) {
                String child = membership.getString("childName");
                children.add(this.myInterner.intern(child));
                membership = memberships.next();
            }
            HashSet<String> hashSet = children;
            return hashSet;
        }
    }

    @Override
    public <T> List<String> search(long directoryId, MembershipQuery<T> query) {
        if (OfBizInternalMembershipDao.canUseCacheSearch(query)) {
            return this.searchCache(directoryId, query);
        }
        PrimitiveMap.Builder filter = PrimitiveMap.builder();
        filter.put("directoryId", directoryId);
        if (query.isFindChildren()) {
            filter.putCaseInsensitive("lowerParentName", query.getEntityNameToMatch());
        } else {
            filter.putCaseInsensitive("lowerChildName", query.getEntityNameToMatch());
        }
        if (query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user())) {
            filter.put("membershipType", MembershipType.GROUP_USER.name());
        } else {
            filter.put("membershipType", MembershipType.GROUP_GROUP.name());
        }
        List<GenericValue> memberships = this.findMemberships(filter.build());
        ArrayList<String> entityNames = new ArrayList<String>(memberships.size());
        for (GenericValue membership : memberships) {
            entityNames.add(query.isFindChildren() ? membership.getString("childName") : membership.getString("parentName"));
        }
        return entityNames;
    }

    private List<String> searchCache(long directoryId, MembershipQuery<?> query) {
        MembershipType type = query.getEntityToReturn().equals((Object)EntityDescriptor.user()) || query.getEntityToMatch().equals((Object)EntityDescriptor.user()) ? MembershipType.GROUP_USER : MembershipType.GROUP_GROUP;
        if (query.isFindChildren()) {
            return this.getChildrenOfGroupFromCache(directoryId, query.getEntityNameToMatch(), type);
        }
        return this.getParentsForMemberFromCache(directoryId, query.getEntityNameToMatch(), type);
    }

    private List<String> getParentsForMemberFromCache(long directoryId, String childName, MembershipType type) {
        Set parents = (Set)this.parentsCache.get((Object)MembershipKey.getKey(directoryId, childName, type));
        if (parents == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> groupNames = new ArrayList<String>(parents.size());
        for (String parent : parents) {
            groupNames.add(parent);
        }
        return groupNames;
    }

    private List<String> getChildrenOfGroupFromCache(long directoryId, String groupName, MembershipType type) {
        Set children = (Set)this.childrenCache.get((Object)MembershipKey.getKey(directoryId, groupName, type));
        if (children == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> childNames = new ArrayList<String>(children.size());
        for (String child : children) {
            childNames.add(child);
        }
        return childNames;
    }

    private static boolean canUseCacheSearch(MembershipQuery<?> query) {
        return query.getStartIndex() == 0 && query.getMaxResults() == -1;
    }

    private List<GenericValue> findMemberships(Map<String, Object> filter) {
        return this.ofBizDelegator.findByAnd("Membership", filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findChildren(long directoryId, MembershipType membershipType, String parent) {
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr parentCondition = new EntityExpr("lowerParentName", EntityOperator.EQUALS, (Object)parent);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)membershipType.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)parentCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_LOWERCHILDNAME, null, null);){
            HashSet<String> children = new HashSet<String>(4096);
            GenericValue membership = memberships.next();
            while (membership != null) {
                String child = membership.getString("lowerChildName");
                children.add(this.myInterner.intern(child));
                membership = memberships.next();
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf(children);
            return immutableSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findParents(long directoryId, MembershipType membershipType, String child) {
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        EntityExpr childCondition = new EntityExpr("lowerChildName", EntityOperator.EQUALS, (Object)child);
        EntityExpr typeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)membershipType.name());
        EntityConditionList condition = new EntityConditionList((List)ImmutableList.of((Object)directoryCondition, (Object)childCondition, (Object)typeCondition), EntityOperator.AND);
        try (OfBizListIterator memberships = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, FIELD_LIST_LOWERPARENTNAME, null, null);){
            HashSet<String> parents = new HashSet<String>(64);
            GenericValue membership = memberships.next();
            while (membership != null) {
                String parent = membership.getString("lowerParentName");
                parents.add(this.myInterner.intern(parent));
                membership = memberships.next();
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf(parents);
            return immutableSet;
        }
    }

    @Override
    public void flushCache() {
        this.parentsCache.removeAll();
        this.childrenCache.removeAll();
    }

    private void invalidateChildrenCacheEntry(Long directoryId, String parentName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, parentName, type);
        this.childrenCache.remove((Object)key);
    }

    private void invalidateParentsCacheEntry(Long directoryId, String childName, MembershipType type) {
        MembershipKey key = MembershipKey.getKey(directoryId, childName, type);
        this.parentsCache.remove((Object)key);
    }

    private class ChildrenLoader
    implements CacheLoader<MembershipKey, Set<String>> {
        private ChildrenLoader() {
        }

        @Nonnull
        public Set<String> load(@Nonnull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findChildren(key.getDirectoryId(), key.getType(), key.getName());
        }
    }

    private class ParentsLoader
    implements CacheLoader<MembershipKey, Set<String>> {
        private ParentsLoader() {
        }

        @Nonnull
        public Set<String> load(@Nonnull MembershipKey key) {
            return OfBizInternalMembershipDao.this.findParents(key.getDirectoryId(), key.getType(), key.getName());
        }
    }
}

