/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.exception.ParseException;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nullable;

public class DatabaseCollationReader {
    private static final String ORACLE_GET_COLLATION_SQL = "SELECT VALUE from NLS_DATABASE_PARAMETERS WHERE PARAMETER='NLS_SORT'";
    private static final String MYSQL_GET_COLLATION_SQL = "SELECT DEFAULT_COLLATION_NAME from information_schema.SCHEMATA S where SCHEMA_NAME = ?";
    private static final String POSTGRES_GET_COLLATION_SQL = "SELECT datcollate FROM pg_database WHERE datname = ?";
    private static final String SQL_SERVER_GET_COLLATION_SQL = "SELECT collation_name FROM sys.databases WHERE name=?";

    private DatabaseCollationReader() {
    }

    @Nullable
    public static String findCollation(Connection connection, DatabaseConfig databaseConfig) throws SQLException, ParseException {
        try (PreparedStatement ps = DatabaseCollationReader.generateCollationQuery(databaseConfig, connection);){
            if (ps != null) {
                ResultSet rs = ps.executeQuery();
                rs.next();
                String string = rs.getString(1);
                return string;
            }
            String string = null;
            return string;
        }
    }

    private static PreparedStatement generateCollationQuery(DatabaseConfig databaseConfig, Connection connection) throws SQLException, ParseException {
        PreparedStatement ps = null;
        if (databaseConfig.isOracle()) {
            ps = connection.prepareStatement(ORACLE_GET_COLLATION_SQL);
        } else if (databaseConfig.isMySql()) {
            ps = connection.prepareStatement(MYSQL_GET_COLLATION_SQL);
            ps.setString(1, DatabaseCollationReader.getDatabaseName(databaseConfig, connection));
        } else if (databaseConfig.isPostgres()) {
            ps = connection.prepareStatement(POSTGRES_GET_COLLATION_SQL);
            ps.setString(1, DatabaseCollationReader.getDatabaseName(databaseConfig, connection));
        } else if (databaseConfig.isSqlServer()) {
            ps = connection.prepareStatement(SQL_SERVER_GET_COLLATION_SQL);
            ps.setString(1, DatabaseCollationReader.getDatabaseName(databaseConfig, connection));
        }
        return ps;
    }

    private static String getDatabaseName(DatabaseConfig databaseConfig, Connection connection) throws ParseException, SQLException {
        JdbcUrlParser urlParser = DatabaseType.forDatabaseTypeName(databaseConfig.getDatabaseType()).getJdbcUrlParser();
        String url = connection.getMetaData().getURL();
        return urlParser.parseUrl(url).getInstance();
    }

    @VisibleForTesting
    static String[] getCollationQueries() {
        return new String[]{ORACLE_GET_COLLATION_SQL, MYSQL_GET_COLLATION_SQL, POSTGRES_GET_COLLATION_SQL, SQL_SERVER_GET_COLLATION_SQL};
    }
}

