/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.listeners.history;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.AbstractIssueEventListener;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueAssignHistoryListener
extends AbstractIssueEventListener {
    private static final Logger log = LoggerFactory.getLogger(IssueAssignHistoryListener.class);

    public void issueAssigned(IssueEvent event) {
        ApplicationUser user = event.getUser();
        ApplicationUser assignee = event.getIssue().getAssignee();
        if (assignee != null && user != null) {
            UserHistoryManager userHistoryManager = (UserHistoryManager)ComponentAccessor.getComponent(UserHistoryManager.class);
            userHistoryManager.addUserToHistory(UserHistoryItem.ASSIGNEE, user, assignee);
            userHistoryManager.addUserToHistory(UserHistoryItem.USED_USER, user, assignee);
        }
    }

    public boolean isInternal() {
        return true;
    }
}

