/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.mau;

import com.atlassian.analytics.api.events.MauEvent;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.core.util.Clock;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.event.mau.LastSentKey;
import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginAccessor;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MauEventServiceImpl
implements MauEventService {
    private final ProjectTypeManager projectTypeManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final EventPublisher eventPublisher;
    private final Clock clock;
    private final JiraProperties jiraProperties;
    private final Cache<LastSentKey, Long> lastSentCache;

    public MauEventServiceImpl(ProjectTypeManager projectTypeManager, JiraAuthenticationContext jiraAuthenticationContext, CacheManager cacheManager, EventPublisher eventPublisher, Clock clock, JiraProperties jiraProperties, PluginAccessor pluginAccessor) {
        this.projectTypeManager = projectTypeManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventPublisher = eventPublisher;
        this.clock = clock;
        this.jiraProperties = jiraProperties;
        this.lastSentCache = cacheManager.getCache(MauEventServiceImpl.class.getName() + ".lastSent", null, new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    public void setApplicationForThread(@Nonnull MauApplicationKey applicationKey) {
        JiraAuthenticationContextImpl.getRequestCache().put("jira.mau.event.application.cache", applicationKey);
    }

    public void setApplicationForThreadBasedOnProject(@Nullable Project project) {
        if (project == null) {
            return;
        }
        Option application = this.projectTypeManager.getApplicationWithType(project.getProjectTypeKey());
        MauApplicationKey mauKey = (MauApplicationKey)application.map(app -> MauApplicationKey.forApplication((ApplicationKey)app.getKey())).getOrElse((Object)MauApplicationKey.unknown());
        this.setApplicationForThread(mauKey);
    }

    public void triggerEvent() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.isAnonymous(user)) {
            return;
        }
        LastSentKey key = this.getKeyWithCurrentApplication();
        long currentTime = this.clock.getCurrentDate().getTime();
        if (!this.jiraProperties.isDevMode() && this.wasLastSentLessThanFiveMinutesAgo(key, currentTime)) {
            return;
        }
        this.eventPublisher.publish((Object)new MauEvent.Builder().application(key.getApplicationKey().getKey()).build(key.getEmail()));
        this.lastSentCache.put((Object)key, (Object)currentTime);
    }

    @Nullable
    public LastSentKey getKeyWithCurrentApplication() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.isAnonymous(user)) {
            return null;
        }
        MauApplicationKey mauApplicationKey = Optional.ofNullable((MauApplicationKey)JiraAuthenticationContextImpl.getRequestCache().get("jira.mau.event.application.cache")).orElse(MauApplicationKey.unknown());
        String emailAddress = user.getEmailAddress();
        long userId = user.getId();
        return new LastSentKey(emailAddress, userId, mauApplicationKey);
    }

    private boolean isAnonymous(ApplicationUser user) {
        return user == null;
    }

    private boolean wasLastSentLessThanFiveMinutesAgo(LastSentKey key, long currentTime) {
        long lastSent = (Long)Optional.ofNullable(this.lastSentCache.get((Object)key)).orElse(0L);
        return lastSent > currentTime - TimeUnit.MINUTES.toMillis(5L);
    }
}

