/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalLabel;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.LabelParser;
import com.atlassian.jira.imports.project.parser.LabelParserImpl;
import com.atlassian.jira.imports.project.transformer.LabelTransformer;
import com.atlassian.jira.imports.project.transformer.LabelTransformerImpl;
import java.util.Map;
import java.util.concurrent.Executor;

public class LabelsPersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ProjectImportResults projectImportResults;
    private final BackupSystemInformation backupSystemInformation;
    private LabelParser labelParser;
    private LabelTransformer labelTransformer;

    public LabelsPersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportResults = projectImportResults;
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.backupSystemInformation = backupSystemInformation;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("Label".equals(entityName)) {
            final ExternalLabel externalLabel = this.getLabelParser().parse(attributes);
            final ExternalLabel transformedExternalLabel = this.getLabelTransformer().transform(this.projectImportMapper, externalLabel);
            if (transformedExternalLabel.getCustomFieldId() == null) {
                this.execute(new Runnable(){

                    @Override
                    public void run() {
                        Long labelId = LabelsPersisterHandler.this.projectImportPersister.createEntity(LabelsPersisterHandler.this.getLabelParser().getEntityRepresentation(transformedExternalLabel));
                        if (labelId == null) {
                            String issueKey = LabelsPersisterHandler.this.backupSystemInformation.getIssueKeyForId(externalLabel.getIssueId());
                            LabelsPersisterHandler.this.projectImportResults.addError(LabelsPersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.label.error", externalLabel.getId(), issueKey));
                        }
                    }
                });
            }
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    LabelParser getLabelParser() {
        if (this.labelParser == null) {
            this.labelParser = new LabelParserImpl();
        }
        return this.labelParser;
    }

    LabelTransformer getLabelTransformer() {
        if (this.labelTransformer == null) {
            this.labelTransformer = new LabelTransformerImpl();
        }
        return this.labelTransformer;
    }
}

