/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.imports.project.core.EntityRepresentation;
import com.atlassian.jira.imports.project.core.EntityRepresentationImpl;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProjectRoleActorParserImpl
implements ProjectRoleActorParser {
    private static final String ID = "id";
    private static final String PID = "pid";
    private static final String PROJECT_ROLE_ID = "projectroleid";
    private static final String ROLE_TYPE = "roletype";
    private static final String ROLE_TYPE_PARAMETER = "roletypeparameter";

    @Override
    public ExternalProjectRoleActor parse(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null");
        }
        String id = (String)attributes.get(ID);
        String projectId = (String)attributes.get(PID);
        String projectRoleId = (String)attributes.get(PROJECT_ROLE_ID);
        String roleType = (String)attributes.get(ROLE_TYPE);
        String roleTypeParameter = (String)attributes.get(ROLE_TYPE_PARAMETER);
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for ProjectRoleActor.");
        }
        if (StringUtils.isEmpty((String)projectRoleId)) {
            throw new ParseException("No 'projectroleid' field for ProjectRoleActor " + id + ".");
        }
        if (StringUtils.isEmpty((String)roleTypeParameter)) {
            throw new ParseException("No 'roletypeparameter' field for ProjectRoleActor " + id + ".");
        }
        if (StringUtils.isEmpty((String)roleType)) {
            throw new ParseException("No 'roletype' field for ProjectRoleActor " + id + ".");
        }
        return new ExternalProjectRoleActor(id, projectId, projectRoleId, roleType, roleTypeParameter);
    }

    @Override
    public EntityRepresentation getEntityRepresentation(ExternalProjectRoleActor projectRoleActor) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(ID, projectRoleActor.getId());
        attributes.put(PID, projectRoleActor.getProjectId());
        attributes.put(PROJECT_ROLE_ID, projectRoleActor.getRoleId());
        attributes.put(ROLE_TYPE, projectRoleActor.getRoleType());
        attributes.put(ROLE_TYPE_PARAMETER, projectRoleActor.getRoleActor());
        return new EntityRepresentationImpl("ProjectRoleActor", attributes);
    }
}

