/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.parser;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.parser.ProjectVersionParser;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ProjectVersionParserImpl
implements ProjectVersionParser {
    @Override
    public ExternalVersion parse(Map attributes) throws ParseException {
        if (attributes == null) {
            throw new IllegalArgumentException("The 'attributes' parameter cannot be null");
        }
        String id = (String)attributes.get("id");
        String projectId = (String)attributes.get("project");
        String name = (String)attributes.get("name");
        String description = (String)attributes.get("description");
        String sequence = (String)attributes.get("sequence");
        if (StringUtils.isEmpty((String)id)) {
            throw new ParseException("No 'id' field for ProjectVersion.");
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new ParseException("No 'name' field for ProjectVersion " + id + ".");
        }
        if (StringUtils.isEmpty((String)sequence)) {
            throw new ParseException("No 'sequence' field for ProjectVersion " + id + ".");
        }
        if (StringUtils.isEmpty((String)projectId)) {
            throw new ParseException("No 'project' field for ProjectVersion " + id + ".");
        }
        ExternalVersion externalVersion = new ExternalVersion(name);
        externalVersion.setDescription(description);
        externalVersion.setSequence(new Long(sequence));
        externalVersion.setId(id);
        externalVersion.setProjectId(projectId);
        externalVersion.setReleased(attributes.get("released") != null);
        String releasedDate = (String)attributes.get("releasedate");
        if (releasedDate != null) {
            externalVersion.setReleaseDate((Date)Timestamp.valueOf(releasedDate));
        }
        externalVersion.setArchived(attributes.get("archived") != null);
        return externalVersion;
    }
}

