/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.index.IssueIndexHelper;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.NullAwareIssueIdsIssueIterable;
import com.atlassian.jira.index.ha.ReindexMetadata;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.FieldHitCollector;
import com.atlassian.jira.issue.util.IssueObjectIssuesIterable;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.index.SharedEntityIndexManager;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.task.CompositeProgressSink;
import com.atlassian.jira.task.LoggingProgressSink;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ZipUtils;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.util.index.IndexingCounterManager;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Collector;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIndexRecoveryManager
implements IndexRecoveryManager {
    private static final Logger LOG = Logger.getLogger(DefaultIndexRecoveryManager.class);
    private final SearchProvider searchProvider;
    private final OfBizDelegator delegator;
    private final IssueBatcherFactory issueBatcherFactory;
    private final IssueManager issueManager;
    private final IssueIndexer issueIndexer;
    private final IndexLifecycleManager indexLifecycleManager;
    private final IndexPathManager indexPathManager;
    private final IssueFactory issueFactory;
    private final SharedEntityIndexManager sharedEntityIndexManager;
    private final IndexingCounterManager indexingCounterManager;
    private final IssueIndexManager indexManager;
    private final AtomicBoolean recoveryInProgress;

    public DefaultIndexRecoveryManager(SearchProvider searchProvider, OfBizDelegator delegator, IssueBatcherFactory issueBatcherFactory, IssueManager issueManager, IssueIndexer issueIndexer, IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager, IssueFactory issueFactory, SharedEntityIndexManager sharedEntityIndexManager, IndexingCounterManager indexingCounterManager, IssueIndexManager indexManager) {
        this.searchProvider = searchProvider;
        this.delegator = delegator;
        this.issueBatcherFactory = issueBatcherFactory;
        this.issueManager = issueManager;
        this.issueIndexer = issueIndexer;
        this.indexLifecycleManager = indexLifecycleManager;
        this.indexPathManager = indexPathManager;
        this.issueFactory = issueFactory;
        this.sharedEntityIndexManager = sharedEntityIndexManager;
        this.indexingCounterManager = indexingCounterManager;
        this.indexManager = indexManager;
        this.recoveryInProgress = new AtomicBoolean(false);
    }

    @Override
    public IndexCommandResult recoverIndexFromBackup(File recoveryFile, TaskProgressSink taskProgressSink) throws IndexException {
        File workDir = new File(this.indexPathManager.getIndexRootPath(), "JIRAIndexRestore");
        if (!this.recoveryInProgress.compareAndSet(false, true)) {
            throw new IndexException("Index recovery already in progress");
        }
        try {
            ZipUtils.unzip(recoveryFile, workDir);
            CompositeProgressSink compositeSink = new CompositeProgressSink(taskProgressSink, new LoggingProgressSink(LOG, "Recovering search indexes - {0}% complete...", 1));
            long startTime = System.currentTimeMillis();
            ReplaceIndexRunner runner = new ReplaceIndexRunner(workDir, compositeSink, this.indexLifecycleManager, this.indexPathManager);
            if (!this.indexManager.withReindexLock((Runnable)runner)) {
                throw new IndexException("Failed to acquire reindex lock");
            }
            if (runner.getDateRange() != null) {
                try {
                    this.reindexIssuesIn(runner.getDateRange(), compositeSink);
                }
                catch (IndexException e) {
                    throw new RuntimeException(e);
                }
                catch (SearchException e) {
                    throw new RuntimeException(e);
                }
            }
            compositeSink.makeProgress(80L, "Recovering", "Recovered issue index");
            this.sharedEntityIndexManager.reIndexAll(Contexts.nullContext());
            this.indexingCounterManager.incrementValue();
            compositeSink.makeProgress(100L, "Recovering", "Recovered all indexes");
            IndexCommandResult indexCommandResult = new IndexCommandResult(System.currentTimeMillis() - startTime);
            return indexCommandResult;
        }
        catch (IOException e) {
            throw new IndexException((Exception)e);
        }
        finally {
            FileUtils.deleteQuietly((File)workDir);
            this.recoveryInProgress.set(false);
        }
    }

    @Override
    public void reindexIssuesIn(DateUtils.DateRange range, TaskProgressSink taskProgressSink) throws IndexException, SearchException {
        if (range.startDate.before(range.endDate)) {
            try {
                this.reindexUsingDatabaseLatest(range);
            }
            catch (GenericEntityException e) {
                throw new RuntimeException(e);
            }
        } else if (range.startDate.after(range.endDate)) {
            this.reindexUsingLucene(range, null);
        }
        taskProgressSink.makeProgress(60L, "Recovering", "Recovered added and updated issues");
        this.deIndexDeletedIssues();
        taskProgressSink.makeProgress(80L, "Recovering", "Cleaned removed issues");
    }

    private void reindexUsingDatabaseLatest(DateUtils.DateRange range) throws IndexException, GenericEntityException {
        EntityExpr ge = new EntityExpr("updated", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(range.startDate.getTime()));
        EntityExpr le = new EntityExpr("updated", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(range.endDate.getTime()));
        EntityConditionList condition = new EntityConditionList(Arrays.asList(ge, le), EntityOperator.AND);
        Context context = Contexts.nullContext();
        IssuesBatcher batches = this.issueBatcherFactory.getBatcher((EntityCondition)condition);
        for (IssuesIterable batch : batches) {
            this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batch, context, IssueIndexingParams.INDEX_ALL, false);
        }
    }

    private void reindexUsingLucene(DateUtils.DateRange range, ApplicationUser user) throws SearchException, IndexException {
        FieldHitCollector collector = new FieldHitCollector("issue_id");
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.where().addDateRangeCondition("updated", range.endDate, range.startDate);
        this.searchProvider.searchOverrideSecurity(queryBuilder.buildQuery(), user, (Collector)collector);
        Iterable issueIds = Iterables.transform(collector.getValues(), (Function)new Function<String, Long>(){

            public Long apply(@Nullable String input) {
                return Long.valueOf(input);
            }
        });
        NullAwareIssueIdsIssueIterable batch = new NullAwareIssueIdsIssueIterable(issueIds, this.issueManager);
        this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batch, Contexts.nullContext(), IssueIndexingParams.INDEX_ALL, false);
    }

    private void deIndexDeletedIssues() throws SearchException {
        IssueIndexHelper issueIndexHelper = new IssueIndexHelper(this.issueManager, this.issueIndexer, this.issueFactory);
        long[] indexIssueIds = issueIndexHelper.getAllIssueIds();
        Set<Long> dbIssueIds = Select.columns("id").from("Issue").runWith(this.delegator).consumeWith(this.createIssueIdsCollector(indexIssueIds.length));
        ArrayList<MutableIssue> deleted = new ArrayList<MutableIssue>();
        long[] lArray = indexIssueIds;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long id = lArray[i];
            if (dbIssueIds.contains(id)) continue;
            GenericValue gv = this.delegator.makeValue("Issue", (Map)new FieldMap("id", (Object)id));
            deleted.add(this.issueFactory.getIssue(gv));
        }
        if (!deleted.isEmpty()) {
            IssueObjectIssuesIterable issues = new IssueObjectIssuesIterable(deleted);
            this.issueIndexer.deindexIssues((EnclosedIterable<Issue>)issues, Contexts.nullContext());
        }
    }

    private EntityListConsumer<GenericValue, Set<Long>> createIssueIdsCollector(final int size) {
        return new EntityListConsumer<GenericValue, Set<Long>>(){
            private final Set<Long> issueIds;
            {
                this.issueIds = Sets.newHashSetWithExpectedSize((int)size);
            }

            @Override
            public void consume(GenericValue entity) {
                this.issueIds.add(entity.getLong("id"));
            }

            @Override
            public Set<Long> result() {
                return this.issueIds;
            }
        };
    }

    @Override
    public DateUtils.DateRange getDurationToRecover() {
        Date latestIndexDate = this.getLatestIndexDate(null);
        Date latestDbDate = this.getLatestDbDate();
        if (latestDbDate == null || latestIndexDate == null) {
            return null;
        }
        LOG.info((Object)String.format("Latest index date: {%1$tF %1$tT}, Latest DB date: {%2$tF %2$tT}", latestIndexDate, latestDbDate));
        return new DateUtils.DateRange(latestIndexDate, latestDbDate);
    }

    private Date getLatestIndexDate(ApplicationUser user) {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        queryBuilder.orderBy().updatedDate(SortOrder.DESC);
        try {
            PagerFilter filter = new PagerFilter(0, 1);
            List issues = this.searchProvider.searchOverrideSecurity(queryBuilder.buildQuery(), user, filter, null).getIssues();
            if (issues.size() > 0) {
                return ((Issue)issues.get(0)).getUpdated();
            }
        }
        catch (SearchException e) {
            LOG.error((Object)"Error searching for issues", (Throwable)e);
        }
        return null;
    }

    private Date getLatestDbDate() {
        GenericValue lastUpdatedIssueGV = (GenericValue)Select.columns("id", "updated").from("Issue").orderBy("updated DESC").limit(1).runWith(this.delegator).singleValue();
        return lastUpdatedIssueGV == null ? null : new Date(lastUpdatedIssueGV.getTimestamp("updated").getTime());
    }

    public int size() {
        return 100;
    }

    public boolean isEmpty() {
        return false;
    }

    private class ReplaceIndexRunner
    implements Runnable {
        private final File workDir;
        private final TaskProgressSink taskProgressSink;
        private final IndexLifecycleManager indexLifecycleManager;
        private final IndexPathManager indexPathManager;
        private DateUtils.DateRange range;

        ReplaceIndexRunner(File workDir, TaskProgressSink taskProgressSink, IndexLifecycleManager indexLifecycleManager, IndexPathManager indexPathManager) {
            this.workDir = workDir;
            this.taskProgressSink = taskProgressSink;
            this.indexLifecycleManager = indexLifecycleManager;
            this.indexPathManager = indexPathManager;
            this.range = null;
        }

        @Override
        public void run() {
            this.taskProgressSink.makeProgress(1L, "Restoring", "Replacing indexes");
            this.indexLifecycleManager.deactivate();
            this.removeIndexes();
            try {
                this.replaceIndexes(this.workDir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.indexLifecycleManager.shutdown();
                this.indexLifecycleManager.activate(Contexts.nullContext(), false);
            }
            this.taskProgressSink.makeProgress(20L, "Restoring", "Restored index backup");
            this.range = this.calculateDurationToRecover();
        }

        private DateUtils.DateRange calculateDurationToRecover() {
            DateUtils.DateRange dateRange = null;
            try {
                Date latestDbDate;
                ReindexMetadata metadata = new ReindexMetadata(this.workDir);
                Date startTime = metadata.getIndexStartTime();
                if (startTime != null && (latestDbDate = DefaultIndexRecoveryManager.this.getLatestDbDate()) != null) {
                    dateRange = new DateUtils.DateRange(startTime, latestDbDate);
                    LOG.info((Object)String.format("Re-index start time: {%1$tF %1$tT.%1$tL}, Latest DB date: {%2$tF %2$tT.%2$tL}", startTime, latestDbDate));
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Cannot calculate recovery duration", (Throwable)e);
            }
            if (dateRange == null) {
                dateRange = DefaultIndexRecoveryManager.this.getDurationToRecover();
            }
            return dateRange;
        }

        public DateUtils.DateRange getDateRange() {
            return this.range;
        }

        private void removeIndexes() {
            IssueIndexer indexIssuer = (IssueIndexer)ComponentAccessor.getComponent(IssueIndexer.class);
            SharedEntityIndexer sharedEntityIndexer = (SharedEntityIndexer)ComponentAccessor.getComponent(SharedEntityIndexer.class);
            indexIssuer.deleteIndexes();
            sharedEntityIndexer.clear(SearchRequest.ENTITY_TYPE);
            sharedEntityIndexer.clear(PortalPage.ENTITY_TYPE);
        }

        private void replaceIndexes(File workDir) throws IOException {
            File indexDirectory = new File(this.indexPathManager.getIndexRootPath());
            FileUtils.deleteDirectory((File)new File(this.indexPathManager.getIssueIndexPath()));
            FileUtils.deleteDirectory((File)new File(this.indexPathManager.getCommentIndexPath()));
            FileUtils.deleteDirectory((File)new File(this.indexPathManager.getChangeHistoryIndexPath()));
            FileUtils.deleteDirectory((File)new File(this.indexPathManager.getWorklogIndexPath()));
            FileUtils.deleteDirectory((File)new File(this.indexPathManager.getSharedEntityIndexPath()));
            if (!indexDirectory.exists()) {
                indexDirectory.mkdir();
            }
            FileUtils.moveDirectoryToDirectory((File)new File(workDir, "issues"), (File)indexDirectory, (boolean)true);
            FileUtils.moveDirectoryToDirectory((File)new File(workDir, "comments"), (File)indexDirectory, (boolean)true);
            FileUtils.moveDirectoryToDirectory((File)new File(workDir, "changes"), (File)indexDirectory, (boolean)true);
            FileUtils.moveDirectoryToDirectory((File)new File(workDir, "worklogs"), (File)indexDirectory, (boolean)true);
            FileUtils.moveDirectoryToDirectory((File)new File(workDir, "entities"), (File)indexDirectory, (boolean)true);
        }
    }
}

