/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuePropertyClauseValueGenerator
implements ClauseValuesGenerator {
    private static final Logger log = LoggerFactory.getLogger(IssuePropertyClauseValueGenerator.class);
    private final String luceneFieldName;
    private final IssueIndexManager indexManager;

    public IssuePropertyClauseValueGenerator(String luceneFieldName, IssueIndexManager indexManager) {
        this.luceneFieldName = luceneFieldName;
        this.indexManager = indexManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxResults) {
        IndexReader indexReader = this.indexManager.getIssueSearcher().getIndexReader();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        TermEnum termEnum = null;
        try {
            Term term;
            termEnum = indexReader.terms(new Term(this.luceneFieldName, valuePrefix));
            int i = 0;
            while ((term = termEnum.term()).text().startsWith(valuePrefix) && term.field().equals(this.luceneFieldName)) {
                builder.add((Object)new ClauseValuesGenerator.Result(term.text()));
                if (termEnum.next() && ++i < maxResults) continue;
            }
        }
        catch (IOException e) {
            try {
                log.error("IOException when getting possible values of the property on the following lucene field name" + this.luceneFieldName, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(termEnum);
                IOUtils.closeQuietly((Closeable)indexReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)termEnum);
            IOUtils.closeQuietly((Closeable)indexReader);
        }
        IOUtils.closeQuietly((Closeable)termEnum);
        IOUtils.closeQuietly((Closeable)indexReader);
        return new ClauseValuesGenerator.Results((List)ImmutableList.copyOf((Collection)builder.build()));
    }
}

