/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureFlagProvider;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.LogEntry;
import com.atlassian.jira.instrumentation.Statistics;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.logging.log4j.layout.JsonLayout;
import com.atlassian.logging.log4j.layout.json.DefaultJsonDataProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.codehaus.jackson.map.ObjectMapper;

@ParametersAreNonnullByDefault
public class DefaultInstrumentationLogger
implements InstrumentationLogger,
FeatureFlagProvider {
    protected static final String REQUEST_EXECUTION_TIME = "requestExecutionTime";
    protected static final String JIRA_INSTRUMENTATION_LAAS = "jira.instrumentation.laas";
    private static final String JIRA_INSTRUMENTATION_BUFFER_SIZE = "jira.instrumentation.cache.buffersize";
    private static final String INSTRUMENTATION = "instrumentation";
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private static final Logger logger = Logger.getLogger(DefaultInstrumentationLogger.class);
    public static final String SPAN_ID = "spanId";
    public static final String PARENT_SPAN_ID = "parentSpanId";
    private final Buffer instrumentationResults;
    private final Executor pool = Executors.newFixedThreadPool(1);
    private final FeatureFlag loggingToLaasFeature;
    private final FeatureManager featureManager;

    public DefaultInstrumentationLogger(JiraProperties jiraProperties, FeatureManager featureManager) {
        this.instrumentationResults = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(jiraProperties.getInteger(JIRA_INSTRUMENTATION_BUFFER_SIZE) == null ? 100 : jiraProperties.getInteger(JIRA_INSTRUMENTATION_BUFFER_SIZE)));
        this.featureManager = featureManager;
        boolean laasEnabled = jiraProperties.getBoolean(JIRA_INSTRUMENTATION_LAAS);
        this.loggingToLaasFeature = FeatureFlag.featureFlag((String)JIRA_INSTRUMENTATION_LAAS).defaultedTo(laasEnabled);
    }

    @Override
    public void save(String traceId, String path, List<? extends Statistics> requestData, Optional<Long> requestTime) {
        this.save(traceId, Optional.empty(), Optional.empty(), path, requestData, requestTime);
    }

    @Override
    public void save(String traceId, Optional<String> spanId, Optional<String> parentSpanId, String path, List<? extends Statistics> requestData, Optional<Long> requestTime) {
        Objects.requireNonNull(traceId, "traceId");
        Objects.requireNonNull(spanId, SPAN_ID);
        Objects.requireNonNull(parentSpanId, PARENT_SPAN_ID);
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(requestData, "requestData");
        Objects.requireNonNull(requestTime, "requestTime");
        if (requestData.size() > 0) {
            boolean enabled = this.featureManager.isEnabled(this.loggingToLaasFeature);
            CompletableFuture.runAsync(() -> {
                block7: {
                    try {
                        Map<String, List<Statistics>> entryMap = requestData.stream().collect(Collectors.groupingBy(Statistics::getLoggingKey));
                        LogEntry entry = new LogEntry(traceId, path, entryMap);
                        this.instrumentationResults.add((Object)entry);
                        if (!enabled) break block7;
                        try {
                            String logging = this.getJsonString(spanId, parentSpanId, entry, requestTime);
                            logger.info((Object)logging);
                        }
                        catch (RuntimeException e) {
                            logger.debug((Object)"failed to log to LaaS: ", (Throwable)e);
                        }
                        finally {
                            this.cleanMdc();
                        }
                    }
                    catch (RuntimeException e) {
                        logger.debug((Object)"failed to log instrumentation", (Throwable)e);
                    }
                }
            }, this.pool);
        }
    }

    protected String getJsonString(Optional<String> spanId, Optional<String> parentSpanId, LogEntry entry, Optional<Long> requestTime) {
        Objects.requireNonNull(entry);
        JsonLayout jsonLayout = new JsonLayout();
        jsonLayout.activateOptions();
        Jsonable json = writer -> new ObjectMapper().writeValue(writer, (Object)entry);
        MDC.put((String)DefaultJsonDataProvider.MdcKey.REQUEST_ID.getKey(), (Object)entry.getTraceId());
        MDC.put((String)REQUEST_EXECUTION_TIME, (Object)requestTime.orElse(-1L));
        spanId.ifPresent(span -> MDC.put((String)SPAN_ID, (Object)span));
        parentSpanId.ifPresent(parent -> MDC.put((String)PARENT_SPAN_ID, (Object)parent));
        MDC.put((String)INSTRUMENTATION, (Object)json);
        LoggingEvent event = new LoggingEvent(DefaultInstrumentationLogger.class.getCanonicalName(), (Category)logger, (Priority)Level.INFO, (Object)"", null);
        return jsonLayout.format(event);
    }

    protected void cleanMdc() {
        MDC.remove((String)INSTRUMENTATION);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)PARENT_SPAN_ID);
        MDC.remove((String)REQUEST_EXECUTION_TIME);
        MDC.remove((String)DefaultJsonDataProvider.MdcKey.REQUEST_ID.getKey());
    }

    @Override
    public List<LogEntry> getLogEntriesFromBuffer() {
        LogEntry[] logEntries = (LogEntry[])this.instrumentationResults.toArray((Object[])new LogEntry[this.instrumentationResults.size()]);
        return Arrays.stream(logEntries).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void clearMemoryBuffer() {
        this.instrumentationResults.clear();
    }

    public Set<FeatureFlag> getFeatureFlags() {
        return ImmutableSet.of((Object)this.loggingToLaasFeature);
    }
}

