/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.jql;

import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.jira.instrumentation.ResultCounter;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.lucene.search.Collector;

public class QueryCounter {
    private final OpSnapshot jqlExecution;
    private final OpSnapshot dbExecution;
    private final String jqlQuery;
    private final String dbQuery;
    private final Collector collector;

    public QueryCounter(OpSnapshot jqlExecution, String jqlQuery, OpSnapshot dbExecution, String dbQuery, Collector collector) {
        this.collector = collector;
        this.jqlExecution = (OpSnapshot)Assertions.notNull((Object)jqlExecution);
        this.jqlQuery = (String)Assertions.notNull((Object)jqlQuery);
        this.dbExecution = dbExecution;
        this.dbQuery = dbQuery;
    }

    public Map<String, Object> asMap() {
        ResultCounter indexTimer = this.convertSnapshot(this.jqlExecution);
        ResultCounter dbTimer = this.convertSnapshot(this.dbExecution);
        ResultCounter delta = this.computeDelta();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        QueryCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "jql", this.jqlQuery);
        if (this.collector != null) {
            builder.put((Object)"collectorClass", (Object)this.collector.getClass().getSimpleName());
        }
        QueryCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "dbquery", this.dbQuery);
        QueryCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "index", indexTimer);
        QueryCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "db", dbTimer);
        QueryCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "delta", delta);
        return builder.build();
    }

    private ResultCounter convertSnapshot(OpSnapshot opSnapshot) {
        if (opSnapshot == null) {
            return null;
        }
        return new ResultCounter(opSnapshot.getMillisecondsTaken(), opSnapshot.getResultSetSize());
    }

    private ResultCounter computeDelta() {
        if (this.jqlExecution == null || this.dbExecution == null) {
            return null;
        }
        return new ResultCounter(this.jqlExecution.getMillisecondsTaken() - this.dbExecution.getMillisecondsTaken(), this.jqlExecution.getResultSetSize() - this.dbExecution.getResultSetSize());
    }

    private static void addIfNonNull(ImmutableMap.Builder<String, Object> builder, String key, Object value) {
        if (value != null) {
            builder.put((Object)key, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryCounter)) {
            return false;
        }
        QueryCounter that = (QueryCounter)o;
        if (this.jqlExecution != null ? !this.jqlExecution.equals((Object)that.jqlExecution) : that.jqlExecution != null) {
            return false;
        }
        if (this.dbExecution != null ? !this.dbExecution.equals((Object)that.dbExecution) : that.dbExecution != null) {
            return false;
        }
        if (this.jqlQuery != null ? !this.jqlQuery.equals(that.jqlQuery) : that.jqlQuery != null) {
            return false;
        }
        if (this.collector != null ? !this.collector.equals(that.collector) : that.collector != null) {
            return false;
        }
        return this.dbQuery != null ? this.dbQuery.equals(that.dbQuery) : that.dbQuery == null;
    }

    public int hashCode() {
        int result = this.jqlExecution != null ? this.jqlExecution.hashCode() : 0;
        result = 31 * result + (this.dbExecution != null ? this.dbExecution.hashCode() : 0);
        result = 31 * result + (this.jqlQuery != null ? this.jqlQuery.hashCode() : 0);
        result = 31 * result + (this.collector != null ? this.collector.hashCode() : 0);
        result = 31 * result + (this.dbQuery != null ? this.dbQuery.hashCode() : 0);
        return result;
    }
}

