/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.jql;

import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.jira.instrumentation.Statistics;
import com.atlassian.jira.instrumentation.jql.QueryCounter;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.lucene.search.Collector;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public final class QueryStatistics
implements Statistics {
    public static final String QUERY_LAAS_ID = "jqlquery";
    @JsonProperty
    private final String name;
    @JsonProperty
    private final List<String> tags;
    @JsonIgnore
    private List<QueryCounter> executions;
    @JsonIgnore
    private Map<String, Object> otherStats;

    public QueryStatistics(String name, List<String> tags, Map<String, ?> otherStats, List<QueryCounter> executions) {
        this.name = Objects.requireNonNull(name);
        this.tags = ImmutableList.copyOf((Collection)Objects.requireNonNull(tags));
        this.executions = ImmutableList.copyOf((Collection)Objects.requireNonNull(executions));
        this.otherStats = ImmutableMap.copyOf(Objects.requireNonNull(otherStats));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLoggingKey() {
        return QUERY_LAAS_ID;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getStats() {
        if (this.otherStats.size() == 0 && this.executions.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"executions", this.executions.stream().map(QueryCounter::asMap).collect(Collectors.toList()));
        builder.putAll(this.otherStats);
        return builder.build();
    }

    public static List<QueryStatistics> create(@Nonnull String name, @Nonnull OpSnapshot jqlExecution, @Nonnull String jqlQuery, @Nullable Collector collector, @Nullable OpSnapshot dbExecution, @Nullable String dbQuery) {
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"jqlExecution", (Object)jqlExecution);
        Assertions.notNull((String)"jqlQuery", (Object)jqlQuery);
        return QueryStatistics.create(name, new QueryCounter(jqlExecution, jqlQuery, dbExecution, dbQuery, collector));
    }

    public static List<QueryStatistics> create(@Nonnull String name, QueryCounter ... executions) {
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"executions", (Object)executions);
        return Lists.newArrayList((Object[])new QueryStatistics[]{new QueryStatisticsBuilder().withName(name).withExecutions(executions).build()});
    }

    public static class QueryStatisticsBuilder {
        private String name;
        private List<String> tags = Collections.emptyList();
        private List<QueryCounter> executions = Lists.newArrayList();
        private Map<String, ?> otherStats = Collections.emptyMap();

        public QueryStatisticsBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public QueryStatisticsBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public QueryStatisticsBuilder withExecutions(QueryCounter ... executions) {
            this.executions.addAll(Arrays.asList(executions));
            return this;
        }

        public QueryStatisticsBuilder withOtherStats(Map<String, ?> otherStats) {
            this.otherStats = otherStats;
            return this;
        }

        public QueryStatistics build() {
            return new QueryStatistics(this.name, this.tags, this.otherStats, this.executions);
        }
    }
}

