/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.migration.WorkflowMigrationMapping;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueVerifier {
    private static final Logger log = LoggerFactory.getLogger(IssueVerifier.class);

    public ErrorCollection verifyIssue(Issue issue, Map<String, String> workflowMigrationMapping, boolean checkWorkflowIntegrity) {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.checkIssueDetails(issue, (ErrorCollection)errorCollection, constantsManager, checkWorkflowIntegrity);
            String statusId = issue.getString("status");
            String targetStatusId = workflowMigrationMapping.get(statusId);
            Status targetStatus = constantsManager.getStatusObject(targetStatusId);
            if (targetStatus == null) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.target.status", issue.getKey()));
                log.error("Unable to determine the target status for issue '" + issue.getKey() + "'.");
            }
        }
        catch (Exception e) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.encountered.error.processing.issue", issue.getKey()));
            log.error("Encountered an error processing the issue '" + issue.getKey() + "'.", (Throwable)e);
        }
        return errorCollection;
    }

    public ErrorCollection verifyForMigration(Issue issue, List<IssueType> typesNeedingMigration, WorkflowMigrationMapping workflowMigrationMapping, boolean checkWorkflowIntegrity) {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        try {
            this.checkIssueDetails(issue, (ErrorCollection)errorCollection, constantsManager, checkWorkflowIntegrity);
            Status targetStatus = typesNeedingMigration.contains(issue.getIssueType()) ? workflowMigrationMapping.getTargetStatus(issue) : issue.getStatus();
            if (targetStatus == null) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.target.status", "'" + issue.getKey() + "'"));
                log.error("Unable to determine the target status for issue '" + issue.getKey() + "'.");
            }
        }
        catch (Exception e) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.encountered.error.processing.issue", "'" + issue.getKey() + "'"));
            log.error("Encountered an error processing the issue '" + issue.getKey() + "'.", (Throwable)e);
        }
        return errorCollection;
    }

    protected void checkIssueDetails(Issue issue, ErrorCollection errorCollection, ConstantsManager constantsManager, boolean checkWorkflowIntegrity) throws WorkflowException {
        String issueTypeId;
        Status originalStatus;
        Long originalWfIdString = issue.getWorkflowId();
        if (originalWfIdString == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.workflow.entry", "'" + issue.getKey() + "'"));
            log.error("Unable to determine the current workflow entry for issue '" + issue.getKey() + "'.");
        }
        if ((originalStatus = issue.getStatus()) == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.status", "'" + issue.getKey() + "'"));
            log.error("Unable to determine the current status for issue '" + issue.getKey() + "'.");
        }
        if ((issueTypeId = issue.getIssueTypeId()) == null || issue.getIssueType() == null) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.current.issue.type", "'" + issue.getKey() + "'"));
            log.error("Unable to determine the current issue type for issue '" + issue.getKey() + "'.");
        } else if (!constantsManager.getAllIssueTypeObjects().contains(issue.getIssueType())) {
            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.invalid.issue.type", "'" + issue.getKey() + "'"));
            log.error("Issue '" + issue.getKey() + "'  does not have a valid issue type.");
        } else {
            JiraWorkflow originalWorkflow = this.getWorkflowManager().getWorkflow(issue);
            if (originalWorkflow == null) {
                errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.workflow", "'" + issue.getKey() + "'"));
                log.error("Unable to determine the current workflow for issue '" + issue.getKey() + "'.");
            }
            if (checkWorkflowIntegrity) {
                List linkedStatuses;
                if (originalStatus != null && !(linkedStatuses = this.getWorkflowManager().getWorkflow(issue).getLinkedStatusObjects()).contains(originalStatus)) {
                    errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.issue.incorrect.association", "'" + issue.getKey() + "'", "'" + originalStatus.getName() + "'"));
                    log.error("The issue '" + issue.getKey() + "' is incorrectly associated with the status '" + originalStatus.getName() + "'.");
                }
                try {
                    WorkflowStore store = this.getWorkflowManager().getStore();
                    List stepDescriptors = originalWorkflow.getDescriptor().getSteps();
                    for (Object stepDescriptor1 : stepDescriptors) {
                        List workflowSteps;
                        StepDescriptor stepDescriptor = (StepDescriptor)stepDescriptor1;
                        Map stepAttributes = stepDescriptor.getMetaAttributes();
                        Status status = ComponentAccessor.getConstantsManager().getStatusObject((String)stepAttributes.get("jira.status.id"));
                        if (originalStatus == null || !originalStatus.equals(status)) continue;
                        List actions = stepDescriptor.getActions();
                        if (!actions.isEmpty() && (workflowSteps = store.findCurrentSteps(originalWfIdString.longValue())).isEmpty()) {
                            errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.unable.to.determine.current.step", "'" + issue.getKey() + "'"));
                            log.error("Unable to determine the current step for issue for issue '" + issue.getKey() + "'.");
                        }
                        break;
                    }
                }
                catch (StoreException se) {
                    errorCollection.addErrorMessage(this.getI18nBean().getText("admin.errors.error.accessing.workflow.store", "'" + issue.getKey() + "'"));
                    log.error("Error accessing workflow store to determine the current step for issue '" + issue.getKey() + "'.");
                }
            }
        }
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    private WorkflowManager getWorkflowManager() {
        return ComponentAccessor.getWorkflowManager();
    }
}

