/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.strategy.move;

import com.atlassian.jira.issue.attachment.AttachmentFileGetData;
import com.atlassian.jira.issue.attachment.AttachmentGetData;
import com.atlassian.jira.issue.attachment.store.strategy.move.IOUtilsWrapper;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Effects;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResendingAttachmentStreamCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResendingAttachmentStreamCreator.class);
    private final IOUtilsWrapper ioUtilsWrapper;

    public ResendingAttachmentStreamCreator(IOUtilsWrapper ioUtilsWrapper) {
        this.ioUtilsWrapper = ioUtilsWrapper;
    }

    public Pair<InputStream, Effect<Object>> getInputStreamWithCloseHandler(AttachmentGetData attachmentGetData) {
        try {
            if (attachmentGetData instanceof AttachmentFileGetData) {
                AttachmentFileGetData fileGetData = (AttachmentFileGetData)attachmentGetData;
                File file = fileGetData.getFile();
                return this.getInputStreamForFile(file, (Effect<Object>)Effects.noop());
            }
            return this.getStreamCopiedToTemporaryFile(attachmentGetData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Pair<InputStream, Effect<Object>> getStreamCopiedToTemporaryFile(AttachmentGetData attachmentGetData) throws Exception {
        final File tempFile = this.copyStreamToTemporaryFile(attachmentGetData.getInputStream());
        try {
            return this.getInputStreamForFile(tempFile, new Effect<Object>(){

                public void apply(Object ignore) {
                    ResendingAttachmentStreamCreator.this.deleteTemporaryFile(tempFile);
                }
            });
        }
        catch (Exception e) {
            this.deleteTemporaryFile(tempFile);
            throw e;
        }
    }

    private void deleteTemporaryFile(File tempFile) {
        if (!tempFile.delete()) {
            LOGGER.warn("Failed to delete temporary file: " + tempFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyStreamToTemporaryFile(InputStream inputStream) throws IOException {
        File tempFile = this.ioUtilsWrapper.createTempFile("tempAttachment", "att");
        FileOutputStream output = this.ioUtilsWrapper.openOutputStream(tempFile);
        try {
            this.ioUtilsWrapper.copy(inputStream, output);
            File file = tempFile;
            return file;
        }
        finally {
            IOUtils.closeQuietly((Closeable)output);
        }
    }

    private Pair<InputStream, Effect<Object>> getInputStreamForFile(File file, final Effect<Object> effect) throws IOException {
        final InputStream fileInputStream = this.ioUtilsWrapper.openInputStream(file);
        return Pair.of((Object)fileInputStream, (Object)new Effect<Object>(){

            public void apply(Object ignore) {
                try {
                    effect.apply(ignore);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)fileInputStream);
                }
            }
        });
    }
}

