/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.issue.comment.property.CommentPropertyHelper;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CommentBodyCharacterLimitExceededException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentEventPublisher;
import com.atlassian.jira.issue.comments.CommentImpl;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.comments.CommentSearchManager;
import com.atlassian.jira.issue.comments.MutableComment;
import com.atlassian.jira.issue.comments.QueryDSLCommentFactory;
import com.atlassian.jira.issue.fields.TextFieldCharacterLengthValidator;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.model.querydsl.QProjectRole;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraDateUtils;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.json.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mysema.query.Tuple;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.QTuple;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultCommentManager
implements CommentManager,
GroupConfigurable {
    private static final String COMMENT_ID = "id";
    public static final String COMMENT_ENTITY = "Action";
    private static final QTuple COMMENT_PROJECT_ROLE_TUPLE = new QTuple(ImmutableList.builder().addAll((Iterable)Lists.newArrayList((Object[])QAction.ACTION.all())).addAll((Iterable)Lists.newArrayList((Object[])QProjectRole.PROJECT_ROLE.all())).build());
    private final UserManager userManager;
    private final ProjectRoleManager projectRoleManager;
    private final CommentPermissionManager commentPermissionManager;
    private final OfBizDelegator delegator;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final TextFieldCharacterLengthValidator textFieldCharacterLengthValidator;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final CommentPropertyHelper commentPropertyHelper;
    private final CommentSearchManager commentSearchManager;
    private final CommentEventPublisher commentEventPublisher;
    private final IssueUpdater issueUpdater;
    private final DbConnectionManager dbConnectionManager;
    private final QueryDSLCommentFactory queryDSLCommentFactory;

    public DefaultCommentManager(ProjectRoleManager projectRoleManager, CommentPermissionManager commentPermissionManager, OfBizDelegator delegator, JiraAuthenticationContext jiraAuthenticationContext, TextFieldCharacterLengthValidator textFieldCharacterLengthValidator, UserManager userManager, JsonEntityPropertyManager jsonEntityPropertyManager, CommentPropertyHelper commentPropertyHelper, CommentSearchManager commentSearchManager, CommentEventPublisher commentEventPublisher, IssueUpdater issueUpdater, DbConnectionManager dbConnectionManager, QueryDSLCommentFactory queryDSLCommentFactory) {
        this.commentSearchManager = commentSearchManager;
        this.projectRoleManager = projectRoleManager;
        this.commentPermissionManager = commentPermissionManager;
        this.delegator = delegator;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.textFieldCharacterLengthValidator = textFieldCharacterLengthValidator;
        this.userManager = userManager;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.commentPropertyHelper = commentPropertyHelper;
        this.commentEventPublisher = commentEventPublisher;
        this.issueUpdater = issueUpdater;
        this.dbConnectionManager = dbConnectionManager;
        this.queryDSLCommentFactory = queryDSLCommentFactory;
    }

    public ProjectRole getProjectRole(Long projectRoleId) {
        return this.projectRoleManager.getProjectRole(projectRoleId);
    }

    public Comment convertToComment(GenericValue gv) {
        return this.commentSearchManager.convertToComment(gv);
    }

    public Comment getCommentById(Long commentId) {
        return this.commentSearchManager.getCommentById(commentId);
    }

    public MutableComment getMutableComment(Long commentId) {
        return this.commentSearchManager.getMutableComment(commentId);
    }

    public List<Comment> getCommentsForUser(Issue issue, ApplicationUser user) {
        return this.commentSearchManager.getCommentsForUser(issue, user);
    }

    public Comment getLastComment(Issue issue) {
        GenericValue commentGV = (GenericValue)Select.from(COMMENT_ENTITY).whereEqual("issue", issue.getId()).andEqual("type", "comment").orderBy("created DESC").limit(1).runWith(this.delegator).singleValue();
        return commentGV == null ? null : this.convertToComment(commentGV);
    }

    @Nonnull
    public List<Comment> getCommentsForUserSince(@Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Date since) {
        return this.commentSearchManager.getCommentsForUserSince(issue, user, since);
    }

    public List<Comment> getComments(Issue issue) {
        return this.commentSearchManager.getComments(issue);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, boolean dispatchEvent) {
        return this.create(issue, author, body, null, null, dispatchEvent);
    }

    public Comment create(Issue issue, String author, String body, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, body, groupLevel, roleLevelId, new Date(), dispatchEvent);
    }

    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, groupLevel, roleLevelId, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, author, body, groupLevel, roleLevelId, created, created, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, String body, String groupLevel, Long roleLevelId, Date created, Map<String, JSONObject> commentProperties, boolean dispatchEvent) {
        return this.create(issue, author, author, body, groupLevel, roleLevelId, created, created, commentProperties, dispatchEvent, true);
    }

    public Comment create(Issue issue, String author, String body, String groupLevel, Long roleLevelId, Date created, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), body, groupLevel, roleLevelId, created, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent) throws DataAccessException {
        return this.create(issue, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, dispatchEvent, true);
    }

    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), this.userManager.getUserByKeyEvenWhenUnknown(updateAuthor), body, groupLevel, roleLevelId, created, updated, dispatchEvent);
    }

    public Comment create(Issue issue, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent, boolean modifyIssueUpdateDate) {
        return this.create(issue, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, Collections.emptyMap(), dispatchEvent, modifyIssueUpdateDate);
    }

    public Comment create(Issue issue, ApplicationUser author, ApplicationUser updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, Map<String, JSONObject> commentProperties, boolean dispatchEvent, boolean modifyIssueUpdateDate) {
        this.validateCommentBodyLength(body);
        CommentImpl comment = new CommentImpl(this.projectRoleManager, author, updateAuthor, body, groupLevel, roleLevelId, created, updated, issue);
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issue.getId());
        fields.put("type", "comment");
        ApplicationUser commentAuthor = comment.getAuthorApplicationUser();
        ApplicationUser commentUpdateAuthor = comment.getUpdateAuthorApplicationUser();
        fields.put("author", commentAuthor == null ? null : commentAuthor.getKey());
        fields.put("updateauthor", commentUpdateAuthor == null ? null : commentUpdateAuthor.getKey());
        fields.put("body", comment.getBody());
        fields.put("level", comment.getGroupLevel());
        fields.put("rolelevel", comment.getRoleLevelId());
        fields.put("created", new Timestamp(comment.getCreated().getTime()));
        fields.put("updated", new Timestamp(comment.getUpdated().getTime()));
        GenericValue commentGV = EntityUtils.createValue(COMMENT_ENTITY, fields);
        comment.setId(commentGV.getLong(COMMENT_ID));
        if (modifyIssueUpdateDate && comment.getUpdated().getTime() > issue.getUpdated().getTime()) {
            IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
            MutableIssue mutableIssue = issueFactory.getIssue(issue.getGenericValue());
            mutableIssue.setUpdated(new Timestamp(comment.getUpdated().getTime()));
            mutableIssue.store();
        }
        if (commentProperties != null) {
            this.setProperties(author, (Comment)comment, commentProperties);
        }
        if (dispatchEvent) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("eventsource", "action");
            this.commentEventPublisher.publishCommentCreatedEvent((Comment)comment, params);
        }
        return comment;
    }

    private void validateCommentBodyLength(String body) {
        if (this.textFieldCharacterLengthValidator.isTextTooLong(body)) {
            throw new CommentBodyCharacterLimitExceededException(this.textFieldCharacterLengthValidator.getMaximumNumberOfCharacters());
        }
    }

    public Comment create(Issue issue, String author, String updateAuthor, String body, String groupLevel, Long roleLevelId, Date created, Date updated, boolean dispatchEvent, boolean modifyIssueUpdateDate) {
        return this.create(issue, this.userManager.getUserByKeyEvenWhenUnknown(author), this.userManager.getUserByKeyEvenWhenUnknown(updateAuthor), body, groupLevel, roleLevelId, created, updated, dispatchEvent, modifyIssueUpdateDate);
    }

    public void update(Comment comment, boolean dispatchEvent) {
        this.update(comment, Collections.emptyMap(), dispatchEvent);
    }

    public void update(Comment comment, Map<String, JSONObject> commentProperties, boolean dispatchEvent) {
        if (comment == null) {
            throw new IllegalArgumentException("Comment must not be null");
        }
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment ID must not be null");
        }
        this.validateCommentBodyLength(comment.getBody());
        Comment originalComment = this.getCommentById(comment.getId());
        if (originalComment == null) {
            throw new IllegalArgumentException("Can not find a comment in the datastore with id: " + comment.getId());
        }
        if (!this.areCommentsEquivalent(originalComment, comment)) {
            try {
                GenericValue commentGV = this.delegator.findById(COMMENT_ENTITY, comment.getId());
                this.populateGenericValueFromComment(comment, commentGV);
                commentGV.store();
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
            IssueFactory issueFactory = (IssueFactory)ComponentAccessor.getComponentOfType(IssueFactory.class);
            GenericValue issueGV = comment.getIssue().getGenericValue();
            MutableIssue mutableIssue = issueFactory.getIssue(issueGV);
            mutableIssue.setUpdated(UtilDateTime.nowTimestamp());
            mutableIssue.store();
        }
        if (commentProperties != null) {
            this.setProperties(comment.getAuthorApplicationUser(), comment, commentProperties);
        }
        if (dispatchEvent) {
            Map parameters = MapBuilder.build((Object)"eventsource", (Object)"action", (Object)"originalcomment", (Object)originalComment);
            this.commentEventPublisher.publishCommentUpdatedEvent(comment, parameters);
        }
    }

    public ChangeItemBean delete(Comment comment) {
        return this.doDelete(comment, true, this.jiraAuthenticationContext.getLoggedInUser());
    }

    public void delete(Comment comment, boolean dispatchEvent, ApplicationUser user) {
        this.doDelete(comment, dispatchEvent, user);
    }

    private ChangeItemBean doDelete(Comment comment, boolean dispatchEvent, ApplicationUser user) {
        ChangeItemBean changeItemBean = this.constructChangeItemBeanForCommentDelete(comment);
        this.delegator.removeByAnd(COMMENT_ENTITY, (Map)FieldMap.build((String)COMMENT_ID, (Object)comment.getId(), (String)"type", (Object)"comment"));
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.COMMENT_PROPERTY.getDbEntityName(), comment.getId());
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(comment.getIssue(), comment.getIssue(), EventType.ISSUE_COMMENT_DELETED_ID, user);
        issueUpdateBean.setChangeItems((Collection)Lists.newArrayList((Object[])new ChangeItemBean[]{changeItemBean}));
        if (dispatchEvent) {
            issueUpdateBean.setDispatchEvent(true);
            this.commentEventPublisher.publishCommentDeletedEvent(comment);
        }
        this.issueUpdater.doUpdate(issueUpdateBean, false);
        return changeItemBean;
    }

    public void deleteCommentsForIssue(Issue issue) {
        Preconditions.checkArgument((issue != null ? 1 : 0) != 0, (Object)"Cannot remove comments for not specified issue.");
        List commentForIssue = this.dbConnectionManager.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)QAction.ACTION)).leftJoin((EntityPath)QProjectRole.PROJECT_ROLE)).on((Predicate)QProjectRole.PROJECT_ROLE.id.eq(QAction.ACTION.rolelevel))).where((Predicate)QAction.ACTION.issue.eq((Object)issue.getId()).and((Predicate)QAction.ACTION.type.eq((Object)"comment")))).list((Expression)COMMENT_PROJECT_ROLE_TUPLE)).stream().map(tuple -> this.queryDSLCommentFactory.createComment(issue, (Tuple)tuple)).collect(Collectors.toList());
        List commentIds = commentForIssue.stream().map(Comment::getId).collect(Collectors.toList());
        if (commentIds.size() > 0) {
            this.dbConnectionManager.execute(dbConnection -> dbConnection.delete((RelationalPath<?>)QAction.ACTION).where((Predicate)QAction.ACTION.id.in((Collection)commentIds)).execute());
            this.jsonEntityPropertyManager.deleteByEntityNameAndEntityIds(EntityPropertyType.COMMENT_PROPERTY.getDbEntityName(), commentIds);
            commentForIssue.stream().forEach(this.commentEventPublisher::publishCommentDeletedEvent);
        }
    }

    public boolean isUserCommentAuthor(ApplicationUser user, Comment comment) {
        return this.commentPermissionManager.isUserCommentAuthor(user, comment);
    }

    public int swapCommentGroupRestriction(String groupName, String swapGroup) {
        return this.swapCommentFieldRestriction(RestrictionColumn.group, groupName, swapGroup);
    }

    public int swapCommentRoleRestriction(Long roleId, Long swapRoleId) {
        return this.swapCommentFieldRestriction(RestrictionColumn.role, roleId, swapRoleId);
    }

    public long getCountForCommentsRestrictedByGroup(String groupName) {
        return this.getCountForCommentsRestrictedByField(RestrictionColumn.group, groupName);
    }

    public long getCountForCommentsRestrictedByRole(Long roleId) {
        return this.getCountForCommentsRestrictedByField(RestrictionColumn.role, roleId);
    }

    private <T> int swapCommentFieldRestriction(RestrictionColumn column, T fieldValue, T swapFieldValue) {
        if (fieldValue == null) {
            throw new IllegalArgumentException("You must provide a non null " + column.column + " value.");
        }
        if (swapFieldValue == null) {
            throw new IllegalArgumentException("You must provide a non null swap " + column.column + " value.");
        }
        return this.delegator.bulkUpdateByAnd(COMMENT_ENTITY, (Map)FieldMap.build((String)column.column, swapFieldValue), (Map)FieldMap.build((String)column.column, fieldValue, (String)"type", (Object)"comment"));
    }

    private <T> long getCountForCommentsRestrictedByField(RestrictionColumn column, T fieldValue) {
        if (fieldValue == null) {
            throw new IllegalArgumentException("You must provide a non null field value.");
        }
        EntityFieldMap condition = new EntityFieldMap((Map)FieldMap.build((String)column.column, fieldValue, (String)"type", (Object)"comment"), EntityOperator.AND);
        List commentCount = this.delegator.findByCondition("ActionCount", (EntityCondition)condition, (Collection)EasyList.build((Object)"count"), Collections.emptyList());
        if (commentCount != null && commentCount.size() == 1) {
            GenericValue commentCountGV = (GenericValue)commentCount.get(0);
            return commentCountGV.getLong("count");
        }
        throw new DataAccessException("Unable to access the count for the Action table");
    }

    ChangeItemBean constructChangeItemBeanForCommentDelete(Comment comment) {
        String groupLevel = comment.getGroupLevel();
        String roleLevel = comment.getRoleLevel() == null ? null : comment.getRoleLevel().getName();
        String actionLevel = groupLevel == null ? roleLevel : groupLevel;
        String message = actionLevel != null ? this.getText("comment.manager.deleted.comment.with.restricted.level", actionLevel) : comment.getBody();
        return new ChangeItemBean("jira", "Comment", message, null);
    }

    private String getText(String key, String param) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(key, param);
    }

    private void populateGenericValueFromComment(Comment updatedComment, GenericValue commentGV) {
        ApplicationUser updateAuthor = updatedComment.getUpdateAuthorApplicationUser();
        commentGV.setString("updateauthor", updateAuthor == null ? null : updateAuthor.getKey());
        commentGV.setString("body", updatedComment.getBody());
        commentGV.setString("level", updatedComment.getGroupLevel());
        commentGV.set("rolelevel", (Object)updatedComment.getRoleLevelId());
        commentGV.set("updated", (Object)JiraDateUtils.copyOrCreateTimestampNullsafe((Date)updatedComment.getUpdated()));
    }

    private void setProperties(ApplicationUser applicationUser, Comment comment, Map<String, JSONObject> properties) {
        for (Map.Entry<String, JSONObject> property : properties.entrySet()) {
            this.jsonEntityPropertyManager.put(applicationUser, this.commentPropertyHelper.getEntityPropertyType().getDbEntityName(), comment.getId(), property.getKey(), property.getValue().toString(), this.commentPropertyHelper.createSetPropertyEventFunction(), true);
        }
    }

    private boolean areCommentsEquivalent(Comment comment1, Comment comment2) {
        return ObjectUtils.equalsNullSafe((Object)comment1.getBody(), (Object)comment2.getBody()) && ObjectUtils.equalsNullSafe((Object)comment1.getGroupLevel(), (Object)comment2.getGroupLevel()) && ObjectUtils.equalsNullSafe((Object)comment1.getRoleLevelId(), (Object)comment2.getRoleLevelId());
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return this.getCountForCommentsRestrictedByGroup(group.getName()) > 0L;
    }

    private static enum RestrictionColumn {
        role("rolelevel"),
        group("level");

        private final String column;

        private RestrictionColumn(String column) {
            this.column = column;
        }
    }
}

