/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.imports.project.customfield.GroupCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.GroupSelectorField;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.MultiGroupConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.GroupCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.impl.rest.MultiGroupCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBeanBuilder;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class MultiGroupCFType
extends AbstractMultiCFType<Group>
implements GroupSelectorField,
ProjectImportableCustomField,
UserField,
SortableCustomField<String>,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    protected final MultiGroupConverter multiGroupConverter;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private final FieldVisibilityManager fieldVisibilityManager;
    private static final Comparator<Group> NAME_COMPARATOR = new GroupNameComparator();
    private static final String MULTIPLE_PARAM_KEY = "multiple";
    private final GroupCustomFieldImporter groupCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;

    public MultiGroupCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, MultiGroupConverter multiGroupConverter, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, GroupManager groupManager, FieldVisibilityManager fieldVisibilityManager, JiraBaseUrls jiraBaseUrls) {
        super(customFieldValuePersister, genericConfigManager);
        this.multiGroupConverter = multiGroupConverter;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.groupCustomFieldImporter = new GroupCustomFieldImporter(groupManager);
    }

    protected Comparator<Group> getTypeComparator() {
        return NAME_COMPARATOR;
    }

    public Collection<Group> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet groupSet = new HashSet();
        Collection values = parameters.getValuesForNullKey();
        if (values == null || values.isEmpty()) {
            return null;
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            Collection groupNames = this.isMultiple() ? this.multiGroupConverter.extractGroupStringsFromString((String)i.next()) : Lists.newArrayList((Object[])new Object[]{i.next()});
            groupSet.addAll(this.convertDbObjectToTypes(groupNames));
        }
        ArrayList<Group> l = new ArrayList<Group>(groupSet);
        Collections.sort(l, NAME_COMPARATOR);
        return l;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection groups = parameters.getValuesForNullKey();
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        return this.putInvalidGroupsAtFront(groups);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        StringBuilder errors = new StringBuilder();
        for (Object o : relevantParams.getValuesForNullKey()) {
            String singleParam = (String)o;
            Collection groupStrings = this.isMultiple() ? this.multiGroupConverter.extractGroupStringsFromString(singleParam) : Lists.newArrayList((Object[])new String[]{singleParam});
            if (groupStrings == null) {
                return;
            }
            for (String groupString : groupStrings) {
                try {
                    this.multiGroupConverter.getGroup(groupString);
                }
                catch (FieldValidationException e) {
                    if (errors.length() > 0) {
                        errors.append(", ");
                    }
                    errors.append(groupString);
                }
            }
            if (errors == null || errors.length() <= 0) continue;
            String message = this.isMultiple() ? this.getI18nBean().getText("admin.errors.could.not.find.groupnames", (Object)errors) : this.getI18nBean().getText("admin.errors.could.not.find.groupname", (Object)errors);
            errorCollectionToAddTo.addError(config.getCustomField().getId(), message, ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public String getStringFromSingularObject(Group o) {
        return this.multiGroupConverter.getString(o);
    }

    public Group getSingularObjectFromString(String s) throws FieldValidationException {
        return this.multiGroupConverter.getGroup(s);
    }

    public List<FieldIndexer> getRelatedIndexers(CustomField customField) {
        return Lists.newArrayList((Object[])new FieldIndexer[]{new MultiGroupCustomFieldIndexer(this.fieldVisibilityManager, customField, this.multiGroupConverter)});
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        HashMap<String, Object> params = super.getVelocityParameters(issue, field, fieldLayoutItem);
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("hasAdminPermission", this.permissionManager.hasPermission(0, this.authenticationContext.getUser()));
        params.put(MULTIPLE_PARAM_KEY, this.isMultiple());
        return params;
    }

    protected Object convertTypeToDbValue(Group value) {
        return this.multiGroupConverter.getString(value);
    }

    protected Group convertDbValueToType(Object dbValue) {
        return this.multiGroupConverter.getGroup((String)dbValue);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    private Collection<String> putInvalidGroupsAtFront(Collection<String> groups) {
        HashSet<String> retSet = new HashSet<String>();
        StringBuffer errorString = new StringBuffer();
        if (groups != null) {
            for (String groupList : groups) {
                if (this.isMultiple()) {
                    for (String groupString : this.multiGroupConverter.extractGroupStringsFromString(groupList)) {
                        this.populateGroupString(groupString, retSet, errorString);
                    }
                    continue;
                }
                this.populateGroupString(groupList, retSet, errorString);
            }
        }
        ArrayList<String> l = new ArrayList<String>(retSet);
        Collections.sort(l);
        if (errorString.length() > 0) {
            l.add(0, errorString.toString());
        }
        return l;
    }

    private void populateGroupString(String groupString, Set<String> retSet, StringBuffer errorString) {
        try {
            this.multiGroupConverter.getGroup(groupString);
            retSet.add(groupString);
        }
        catch (FieldValidationException e) {
            if (errorString.length() > 0) {
                errorString.append(", ");
            }
            errorString.append(groupString);
        }
    }

    public boolean isMultiple() {
        return Boolean.valueOf((String)this.getDescriptor().getParams().get(MULTIPLE_PARAM_KEY));
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.groupCustomFieldImporter;
    }

    public Query getQueryForGroup(String fieldName, String groupName) {
        return new TermQuery(new Term(fieldName, groupName));
    }

    public int compare(@Nonnull String customFieldObjectValue1, @Nonnull String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiGroup(this);
        }
        return super.accept(visitor);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return new FieldTypeInfo(null, null);
    }

    public JsonType getJsonSchema(CustomField customField) {
        if (this.isMultiple()) {
            return JsonTypeBuilder.customArray((String)"group", (String)this.getKey(), (Long)customField.getIdAsLong());
        }
        return JsonTypeBuilder.custom((String)"group", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Collection groups = this.getValueFromIssue(field, issue);
        return new FieldJsonRepresentation(this.groupsToJsonData(groups));
    }

    private JsonData groupsToJsonData(Collection<Group> groups) {
        if (groups == null) {
            return new JsonData(null);
        }
        if (this.isMultiple()) {
            return new JsonData((Object)GroupJsonBeanBuilder.buildBeans(groups, (JiraBaseUrls)this.jiraBaseUrls));
        }
        if (groups.isEmpty()) {
            return new JsonData(null);
        }
        return new JsonData((Object)new GroupJsonBeanBuilder(this.jiraBaseUrls).group(groups.iterator().next()).build());
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return this.isMultiple() ? new MultiGroupCustomFieldOperationsHandler(field, this.getI18nBean()) : new GroupCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        Collection groups = this.getDefaultValue(config);
        return this.groupsToJsonData(groups);
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiGroup(MultiGroupCFType var1);
    }

    static class MultiGroupCustomFieldIndexer
    extends AbstractCustomFieldIndexer {
        private final CustomField customField;
        private final MultiGroupConverter multiGroupConverter;

        public MultiGroupCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiGroupConverter multiGroupConverter) {
            super(fieldVisibilityManager, customField);
            this.customField = customField;
            this.multiGroupConverter = multiGroupConverter;
        }

        public void addDocumentFieldsSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
        }

        public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NO);
        }

        void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
            List o = (List)this.customField.getValue(issue);
            if (o != null) {
                for (Group group : o) {
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), this.multiGroupConverter.getString(group), Field.Store.YES, indexType));
                }
            }
        }
    }
}

