/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.customfield.UserCustomFieldImporter;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.ApplicationUserBestNameComparator;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.impl.rest.MultiUserCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.UserField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.notification.type.UserCFNotificationTypeAware;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class MultiUserCFType
extends AbstractMultiCFType<ApplicationUser>
implements UserCFNotificationTypeAware,
ProjectImportableCustomField,
UserField,
SortableCustomField<String>,
RestAwareCustomFieldType,
RestCustomFieldTypeOperations {
    protected final MultiUserConverter multiUserConverter;
    private ApplicationProperties applicationProperties;
    private JiraAuthenticationContext authenticationContext;
    private UserSearchService searchService;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final UserCustomFieldImporter userCustomFieldImporter;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserBeanFactory userBeanFactory;

    public MultiUserCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, MultiUserConverter multiUserConverter, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, UserSearchService searchService, FieldVisibilityManager fieldVisibilityManager, JiraBaseUrls jiraBaseUrls, UserBeanFactory userBeanFactory) {
        super(customFieldValuePersister, genericConfigManager);
        this.multiUserConverter = multiUserConverter;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.searchService = searchService;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userBeanFactory = userBeanFactory;
        this.userCustomFieldImporter = new UserCustomFieldImporter();
    }

    protected Comparator<ApplicationUser> getTypeComparator() {
        return new ApplicationUserBestNameComparator(this.authenticationContext.getLocale());
    }

    public void updateValue(CustomField customField, Issue issue, Collection<ApplicationUser> value) {
        super.updateValue(customField, issue, value);
    }

    public String getChangelogValue(CustomField field, Collection<ApplicationUser> values) {
        if (values == null) {
            return "";
        }
        ArrayList<String> applicationUserKeys = new ArrayList<String>(values.size());
        for (ApplicationUser applicationUser : values) {
            applicationUserKeys.add(applicationUser.getKey());
        }
        return ((Object)applicationUserKeys).toString();
    }

    public String getChangelogString(CustomField field, Collection<ApplicationUser> value) {
        String glue = ", ";
        if (value == null) {
            return "";
        }
        StringBuilder changelogStringEntry = new StringBuilder();
        Iterator<ApplicationUser> usersIterator = value.iterator();
        while (usersIterator.hasNext()) {
            ApplicationUser nextUser = usersIterator.next();
            if (nextUser == null) continue;
            changelogStringEntry.append(nextUser.getDisplayName());
            if (!usersIterator.hasNext()) continue;
            changelogStringEntry.append(", ");
        }
        return changelogStringEntry.toString();
    }

    public Collection<ApplicationUser> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet<ApplicationUser> userSet = new HashSet<ApplicationUser>();
        Collection values = parameters.getValuesForNullKey();
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (Object value : values) {
            userSet.addAll(this.convertPresentationStringsToUsers(new ArrayList<String>(this.multiUserConverter.extractUserStringsFromString((String)value))));
        }
        ArrayList<ApplicationUser> l = new ArrayList<ApplicationUser>(userSet);
        Collections.sort(l, new ApplicationUserBestNameComparator(this.authenticationContext.getLocale()));
        return l;
    }

    private Collection<ApplicationUser> convertPresentationStringsToUsers(List<String> presentationStrings) {
        if (presentationStrings == null) {
            return null;
        }
        HashSet<ApplicationUser> result = new HashSet<ApplicationUser>();
        for (String presentationString : presentationStrings) {
            try {
                ApplicationUser user = this.multiUserConverter.getUserFromHttpParameterWithValidation(presentationString);
                if (user == null) continue;
                result.add(user);
            }
            catch (FieldValidationException fieldValidationException) {}
        }
        return result;
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection users = parameters.getValuesForNullKey();
        if (users == null || users.isEmpty()) {
            return null;
        }
        return this.putInvalidUsersAtFront(users);
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        StringBuilder errors = null;
        for (Object o : relevantParams.getValuesForNullKey()) {
            String singleParam = (String)o;
            Collection userStrings = this.multiUserConverter.extractUserStringsFromString(singleParam);
            if (userStrings == null) {
                return;
            }
            for (String user : userStrings) {
                try {
                    this.multiUserConverter.getUserFromHttpParameterWithValidation(user);
                }
                catch (FieldValidationException e) {
                    if (errors == null) {
                        errors = new StringBuilder(user);
                    }
                    errors.append(", ").append(user);
                }
                if (errors == null) continue;
                errorCollectionToAddTo.addError(config.getCustomField().getId(), this.getI18nBean().getText("admin.errors.could.not.find.usernames", (Object)errors), ErrorCollection.Reason.VALIDATION_FAILED);
            }
        }
    }

    public String getStringFromSingularObject(ApplicationUser o) {
        return this.multiUserConverter.getHttpParameterValue(o);
    }

    public ApplicationUser getSingularObjectFromString(String s) throws FieldValidationException {
        return this.multiUserConverter.getUserFromHttpParameterWithValidation(s);
    }

    @Nonnull
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    public List getRelatedIndexers(CustomField customField) {
        return EasyList.build((Object)((Object)new MultiUserCustomFieldIndexer(this.fieldVisibilityManager, customField, this.multiUserConverter)));
    }

    protected Object convertTypeToDbValue(ApplicationUser value) {
        return this.multiUserConverter.getDbString(value);
    }

    protected ApplicationUser convertDbValueToType(Object string) {
        return this.multiUserConverter.getUserFromDbString((String)string);
    }

    private Collection putInvalidUsersAtFront(Collection users) {
        HashSet<String> retSet = new HashSet<String>();
        StringBuilder errorString = null;
        if (users != null) {
            for (Object user : users) {
                String userList = (String)user;
                Iterator iterator = this.multiUserConverter.extractUserStringsFromString(userList).iterator();
                while (iterator.hasNext()) {
                    String s;
                    String userString = s = (String)iterator.next();
                    try {
                        this.multiUserConverter.getUserFromHttpParameterWithValidation(userString);
                        retSet.add(userString);
                    }
                    catch (FieldValidationException e) {
                        if (errorString == null) {
                            errorString = new StringBuilder(userString);
                            continue;
                        }
                        errorString.append(", ").append(userString);
                    }
                }
            }
        }
        ArrayList<String> l = new ArrayList<String>(retSet);
        Collections.sort(l);
        if (errorString != null) {
            l.add(0, errorString.toString());
        }
        return l;
    }

    @Nonnull
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        Map velocityParams = super.getVelocityParameters(issue, field, fieldLayoutItem);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.authenticationContext.getUser());
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        return velocityParams;
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return this.userCustomFieldImporter;
    }

    public int compare(@Nonnull String customFieldObjectValue1, @Nonnull String customFieldObjectValue2, FieldConfig fieldConfig) {
        return customFieldObjectValue1.compareTo(customFieldObjectValue2);
    }

    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitMultiUser(this);
        }
        return super.accept(visitor);
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        String userPickerAutoCompleteUrl = String.format("%s/rest/api/1.0/users/picker?fieldName=%s&query=", this.jiraBaseUrls.baseUrl(), fieldTypeInfoContext.getOderableField().getId());
        return new FieldTypeInfo(null, userPickerAutoCompleteUrl);
    }

    public JsonType getJsonSchema(CustomField customField) {
        return JsonTypeBuilder.customArray((String)"user", (String)this.getKey(), (Long)customField.getIdAsLong());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        return new FieldJsonRepresentation(new JsonData((Object)this.userBeanFactory.createBeanCollection(this.getValueFromIssue(field, issue), this.authenticationContext.getUser())));
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return new MultiUserCustomFieldOperationsHandler(field, this.getI18nBean());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        return new JsonData((Object)this.userBeanFactory.createBeanCollection(this.getDefaultValue(config), this.authenticationContext.getUser()));
    }

    public static interface Visitor<T>
    extends AbstractCustomFieldType.VisitorBase<T> {
        public T visitMultiUser(MultiUserCFType var1);
    }

    static class MultiUserCustomFieldIndexer
    extends AbstractCustomFieldIndexer {
        private final CustomField customField;
        private final MultiUserConverter multiUserConverter;

        public MultiUserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiUserConverter multiUserConverter) {
            super(fieldVisibilityManager, customField);
            this.customField = customField;
            this.multiUserConverter = multiUserConverter;
        }

        public void addDocumentFieldsSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
        }

        public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
            this.addDocumentFields(doc, issue, Field.Index.NO);
        }

        public void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
            List o = (List)this.customField.getValue(issue);
            if (o != null) {
                for (Object anO : o) {
                    ApplicationUser user = (ApplicationUser)anO;
                    String userId = this.multiUserConverter.getDbString(user);
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), userId, Field.Store.YES, indexType));
                }
            }
        }
    }
}

