/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class FieldContextGenerator {
    private FieldVisibilityManager fieldVisibilityManager;

    public FieldContextGenerator(FieldVisibilityManager fieldVisibilityManager) {
        this.fieldVisibilityManager = (FieldVisibilityManager)Assertions.notNull((String)"fieldVisibilityManager", (Object)fieldVisibilityManager);
    }

    public ClauseContext generateClauseContext(List<Project> projects, String fieldId) {
        return new ClauseContextImpl(this.generateSearchContext(projects, fieldId));
    }

    private Set<ProjectIssueTypeContext> generateSearchContext(List<Project> projects, String fieldId) {
        boolean visibleSomewhere = false;
        for (Project project : projects) {
            if (this.fieldVisibilityManager.isFieldHiddenInAllSchemes(project.getId(), fieldId)) continue;
            visibleSomewhere = true;
        }
        if (!visibleSomewhere) {
            return Collections.emptySet();
        }
        return Collections.singleton(ProjectIssueTypeContextImpl.createGlobalContext());
    }
}

