/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogUtils {
    private static final Logger log = LoggerFactory.getLogger(ChangeLogUtils.class);

    @Deprecated
    public static void deleteChangesForIssue(GenericValue issue) {
        OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
        ImmutableMap params = ImmutableMap.of((Object)"issue", (Object)issue.getLong("id"));
        List changeGroups = delegator.findByAnd("ChangeGroup", (Map)params);
        for (GenericValue changeGroup : changeGroups) {
            delegator.removeByAnd("ChangeItem", (Map)ImmutableMap.of((Object)"group", (Object)changeGroup.getLong("id")));
        }
        delegator.removeByAnd("ChangeGroup", (Map)params);
    }

    public static GenericValue createChangeGroup(ApplicationUser changeAuthor, GenericValue before, GenericValue after, Collection<ChangeItemBean> incomingChangeItems, boolean generateChangeItems) {
        OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
        if (generateChangeItems && EntityUtils.identical(before, after) && (incomingChangeItems == null || incomingChangeItems.size() == 0)) {
            return null;
        }
        GenericValue changeGroup = null;
        ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>();
        if (generateChangeItems && !EntityUtils.identical(before, after)) {
            changeItems.addAll(ChangeLogUtils.generateChangeItems(before, after));
        }
        if (incomingChangeItems != null) {
            changeItems.addAll(incomingChangeItems);
        }
        if (!changeItems.isEmpty()) {
            MapBuilder builder = MapBuilder.newBuilder((Object)"issue", (Object)before.getLong("id"));
            builder.add((Object)"author", (Object)ApplicationUsers.getKeyFor(changeAuthor));
            builder.add((Object)"created", (Object)UtilDateTime.nowTimestamp());
            changeGroup = delegator.createValue("ChangeGroup", builder.toMap());
            for (ChangeItemBean cib : changeItems) {
                builder = MapBuilder.newBuilder((Object)"group", (Object)changeGroup.getLong("id"));
                builder.add((Object)"fieldtype", (Object)cib.getFieldType());
                builder.add((Object)"field", (Object)cib.getField());
                builder.add((Object)"oldvalue", (Object)cib.getFrom());
                builder.add((Object)"oldstring", (Object)cib.getFromString());
                builder.add((Object)"newvalue", (Object)cib.getTo());
                builder.add((Object)"newstring", (Object)cib.getToString());
                delegator.createValue("ChangeItem", builder.toMap());
            }
        }
        return changeGroup;
    }

    public static GenericValue createChangeGroup(ApplicationUser changeAuthor, Issue before, Issue after, Collection<ChangeItemBean> incomingChangeItems, boolean generateChangeItems) {
        return ChangeLogUtils.createChangeGroup(changeAuthor, before.getGenericValue(), after.getGenericValue(), incomingChangeItems, generateChangeItems);
    }

    public static List<ChangeItemBean> generateChangeItems(GenericValue before, GenericValue after) {
        List allFieldNames = before.getModelEntity().getAllFieldNames();
        ArrayList<ChangeItemBean> changeItems = new ArrayList<ChangeItemBean>(allFieldNames.size());
        for (String fieldname : allFieldNames) {
            ChangeItemBean changeItem;
            if (fieldname.equals("id") || fieldname.equals("created") || fieldname.equals("updated") || fieldname.equals("workflowId") || fieldname.equals("key") || fieldname.equals("project") || fieldname.equals("fixfor") || fieldname.equals("component") || fieldname.equals("votes") || (changeItem = ChangeLogUtils.generateChangeItem(before, after, fieldname)) == null) continue;
            changeItems.add(changeItem);
        }
        return changeItems;
    }

    public static ChangeItemBean generateChangeItem(GenericValue before, GenericValue after, String fieldname) {
        if (before.get(fieldname) == null && after.get(fieldname) == null) {
            return null;
        }
        if (before.get(fieldname) != null && after.get(fieldname) != null && before.get(fieldname).equals(after.get(fieldname))) {
            return null;
        }
        String from = null;
        String to = null;
        String fromString = null;
        String toString = null;
        if (fieldname.equals("assignee") || fieldname.equals("reporter")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                ApplicationUser fromUser = ChangeLogUtils.getUserManager().getUserByKey(from);
                if (fromUser != null) {
                    fromString = fromUser.getDisplayName();
                } else {
                    log.warn("User: " + from + " not found - change item will be missing full name.");
                }
            }
            if (to != null) {
                ApplicationUser toUser = ChangeLogUtils.getUserManager().getUserByKey(to);
                if (toUser != null) {
                    toString = toUser.getDisplayName();
                } else {
                    log.warn("User: " + to + " not found - change item will be missing full name.");
                }
            }
        } else if (fieldname.equals("type")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ChangeLogUtils.getConstantsManager().getIssueType(from).getName();
            }
            if (to != null) {
                toString = ChangeLogUtils.getConstantsManager().getIssueType(to).getName();
            }
        } else if (fieldname.equals("resolution")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ChangeLogUtils.getConstantsManager().getResolution(from).getName();
            }
            if (to != null) {
                toString = ChangeLogUtils.getConstantsManager().getResolution(to).getName();
            }
        } else if (fieldname.equals("priority")) {
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null) {
                fromString = ChangeLogUtils.getConstantsManager().getPriorityName(from);
            }
            if (to != null) {
                toString = ChangeLogUtils.getConstantsManager().getPriorityName(to);
            }
        } else if (fieldname.equals("timeestimate") || fieldname.equals("timespent")) {
            Long fromValue = before.getLong(fieldname);
            Long toValue = after.getLong(fieldname);
            if (fromValue != null) {
                from = fromValue.toString();
                fromString = from = fromValue.toString();
            }
            if (toValue != null) {
                to = toValue.toString();
                toString = toValue.toString();
            }
        } else if (fieldname.equals("status")) {
            Status toStatus;
            Status fromStatus;
            from = before.getString(fieldname);
            to = after.getString(fieldname);
            if (from != null && (fromStatus = ChangeLogUtils.getConstantsManager().getStatus(from)) != null) {
                fromString = fromStatus.getName();
            }
            if (to != null && (toStatus = ChangeLogUtils.getConstantsManager().getStatus(to)) != null) {
                toString = toStatus.getName();
            }
        } else {
            if (fieldname.equals("security")) {
                from = before.getString(fieldname);
                to = after.getString(fieldname);
                return ChangeLogUtils.generateSecurityChangeItem(fieldname, from, to);
            }
            fromString = before.getString(fieldname);
            toString = after.getString(fieldname);
        }
        return new ChangeItemBean("jira", fieldname, from, fromString, to, toString);
    }

    private static ConstantsManager getConstantsManager() {
        return ComponentAccessor.getConstantsManager();
    }

    public static ChangeItemBean generateSecurityChangeItem(String fieldname, String from, String to) {
        String fromString = null;
        String toString = null;
        if (from != null) {
            try {
                GenericValue fromLevel = ComponentAccessor.getIssueSecurityLevelManager().getIssueSecurityLevel(new Long(from));
                if (fromLevel != null) {
                    fromString = fromLevel.getString("name");
                }
            }
            catch (GenericEntityException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (to != null) {
            try {
                GenericValue toLevel = ComponentAccessor.getIssueSecurityLevelManager().getIssueSecurityLevel(new Long(to));
                if (toLevel != null) {
                    toString = toLevel.getString("name");
                }
            }
            catch (GenericEntityException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (NumberFormatException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new ChangeItemBean("jira", fieldname, from, fromString, to, toString);
    }

    private static String getUserkey(ApplicationUser user) {
        if (user == null) {
            return null;
        }
        ApplicationUser applicationUser = ChangeLogUtils.getUserManager().getUserByName(user.getName());
        return applicationUser.getKey();
    }

    private static UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

