/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class ParentIssueIndexer
extends BaseFieldIndexer {
    private final SubTaskManager subTaskManager;

    public ParentIssueIndexer(FieldVisibilityManager fieldVisibilityManager, SubTaskManager subTaskManager) {
        super(fieldVisibilityManager);
        this.subTaskManager = subTaskManager;
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public String getId() {
        return "parent";
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forIssueParent().getIndexField();
    }

    public void addIndex(Document doc, Issue issue) {
        this.indexLongAsKeyword(doc, this.getDocumentFieldId(), issue.getParentId(), issue);
    }
}

