/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.filters;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.SortedVIntList;

public class IssueIdFilter
extends Filter {
    private final Set<String> issuesIds;

    public IssueIdFilter(Set<String> issuesIds) {
        this.issuesIds = issuesIds;
    }

    public DocIdSet getDocIdSet(IndexReader indexReader) throws IOException {
        if (this.issuesIds.size() == 0) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        if (this.issuesIds.size() < indexReader.maxDoc() / 100) {
            return this.getSortedVIntList(indexReader);
        }
        return this.getOpenBitSet(indexReader);
    }

    private DocIdSet getSortedVIntList(IndexReader indexReader) throws IOException {
        int[] docIds = new int[this.issuesIds.size()];
        int i = 0;
        TermDocs termDocs = indexReader.termDocs();
        for (String issueId : this.issuesIds) {
            Term term = new Term("issue_id", issueId);
            termDocs.seek(term);
            if (!termDocs.next()) continue;
            docIds[i++] = termDocs.doc();
        }
        int[] trimmedDocIds = Arrays.copyOf(docIds, i);
        Arrays.sort(trimmedDocIds);
        return new SortedVIntList(trimmedDocIds, i);
    }

    private OpenBitSet getOpenBitSet(IndexReader indexReader) throws IOException {
        OpenBitSet bits = new OpenBitSet((long)indexReader.maxDoc());
        TermDocs termDocs = indexReader.termDocs();
        for (String issueId : this.issuesIds) {
            Term term = new Term("issue_id", issueId);
            termDocs.seek(term);
            if (!termDocs.next()) continue;
            bits.set((long)termDocs.doc());
        }
        return bits;
    }
}

