/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.handlers;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.handlers.SimpleSearchHandlerFactory;
import com.atlassian.jira.issue.search.searchers.impl.WorkRatioSearcher;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionChecker;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.TimeTrackingPermissionChecker;
import com.atlassian.jira.jql.query.WorkRatioClauseQueryFactory;
import com.atlassian.jira.jql.validator.WorkRatioValidator;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.InjectableComponent;

@InjectableComponent
public final class WorkRatioSearchHandlerFactory
extends SimpleSearchHandlerFactory {
    public WorkRatioSearchHandlerFactory(ComponentFactory factory, WorkRatioClauseQueryFactory workRatioClauseQueryFactory, WorkRatioValidator workRatioValidator, FieldClausePermissionChecker.Factory clausePermissionFactory, ApplicationProperties applicationProperties) {
        super(factory, (ClauseInformation)SystemSearchConstants.forWorkRatio(), WorkRatioSearcher.class, workRatioClauseQueryFactory, null, workRatioValidator, new WorkRatioClausePermissionCheckerFactory(clausePermissionFactory, applicationProperties), new SimpleClauseContextFactory(), null);
    }

    static class WorkRatioClausePermissionCheckerFactory
    implements FieldClausePermissionChecker.Factory {
        private final FieldClausePermissionChecker.Factory clausePermissionFactory;
        private final ApplicationProperties applicationProperties;

        WorkRatioClausePermissionCheckerFactory(FieldClausePermissionChecker.Factory clausePermissionFactory, ApplicationProperties applicationProperties) {
            this.clausePermissionFactory = clausePermissionFactory;
            this.applicationProperties = applicationProperties;
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(Field field) {
            return new TimeTrackingPermissionChecker(this.clausePermissionFactory, this.applicationProperties);
        }

        @Override
        public ClausePermissionChecker createPermissionChecker(String fieldId) {
            return new TimeTrackingPermissionChecker(this.clausePermissionFactory, this.applicationProperties);
        }
    }
}

