/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.subscription;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.subscription.FilterSubscription;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.Map;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendFilterJob
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(SendFilterJob.class);

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        Map parameters = jobRunnerRequest.getJobConfig().getParameters();
        Long subscriptionId = (Long)parameters.get("SUBSCRIPTION_ID");
        try {
            SubscriptionManager dsm = ComponentAccessor.getSubscriptionManager();
            FilterSubscription subscription = dsm.getFilterSubscription(subscriptionId);
            if (subscription == null) {
                return JobRunnerResponse.failed((String)("No filter subscription for id " + subscriptionId));
            }
            dsm.runSubscription(subscription.getId());
            return JobRunnerResponse.success();
        }
        catch (GenericEntityException e) {
            log.error("Filter Subscription failed for id " + subscriptionId, (Throwable)e);
            return JobRunnerResponse.failed((String)("No filter subscription for id " + subscriptionId));
        }
    }
}

