/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.NonInjectableComponent;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonInjectableComponent
public class WorklogAction
extends AbstractIssueAction {
    private static final Logger log = LoggerFactory.getLogger(WorklogAction.class);
    private final boolean canEditWorklog;
    private final boolean canDeleteWorklog;
    private final Worklog worklog;
    private final JiraDurationUtils jiraDurationUtils;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final Locale locale;
    private final Issue issue;
    private final UserFormats userFormats;

    public WorklogAction(IssueTabPanelModuleDescriptor descriptor, Worklog worklog, JiraDurationUtils jiraDurationUtils, boolean canEditWorklog, boolean canDeleteWorklog, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, Locale locale, UserFormats userFormats) {
        super(descriptor);
        this.canDeleteWorklog = canDeleteWorklog;
        this.canEditWorklog = canEditWorklog;
        this.worklog = worklog;
        this.jiraDurationUtils = jiraDurationUtils;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.issue = worklog.getIssue();
        this.locale = locale;
        this.userFormats = userFormats;
    }

    public Date getTimePerformed() {
        return this.worklog.getStartDate();
    }

    protected void populateVelocityParams(Map params) {
        params.put("action", this);
        params.put("worklog", this.getWorklog());
        params.put("content", this.worklog.getComment());
        params.put("userformats", this.userFormats);
        try {
            FieldLayoutItem fieldLayoutItem = this.fieldLayoutManager.getFieldLayout(this.issue).getFieldLayoutItem("worklog");
            if (fieldLayoutItem != null) {
                params.put("content", this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), this.worklog.getComment(), this.issue.getIssueRenderContext()));
            }
        }
        catch (DataAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getPrettyDuration(String duration) {
        return this.jiraDurationUtils.getFormattedDuration(new Long(duration), this.locale);
    }

    public Worklog getWorklog() {
        return this.worklog;
    }

    public boolean isCanDeleteWorklog() {
        return this.canDeleteWorklog;
    }

    public boolean isCanEditWorklog() {
        return this.canEditWorklog;
    }
}

