/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.MovedIssueKey;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Visitor;
import java.util.HashSet;
import java.util.Set;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class MovedIssueKeyStoreImpl
implements MovedIssueKeyStore {
    private EntityEngine entityEngine;
    private OfBizDelegator ofBizDelegator;

    public MovedIssueKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public void recordMovedIssueKey(String oldIssueKey, Long oldIssueId) {
        Delete.from(Entity.MOVED_ISSUE_KEY).whereEqual("oldIssueKey", oldIssueKey).execute(this.entityEngine);
        this.entityEngine.createValue(Entity.MOVED_ISSUE_KEY, new MovedIssueKey(null, oldIssueKey, oldIssueId));
    }

    @Override
    public Long getMovedIssueId(String key) {
        MovedIssueKey movedIssueKey = (MovedIssueKey)Select.from(Entity.MOVED_ISSUE_KEY).whereEqual("oldIssueKey", key).runWith(this.ofBizDelegator).singleValue();
        if (movedIssueKey != null) {
            return movedIssueKey.getIssueId();
        }
        return null;
    }

    @Override
    public Set<String> getMovedIssueKeys(Set<String> keys) {
        if (keys.isEmpty()) {
            return new HashSet<String>();
        }
        final HashSet<String> movedIssueKeys = new HashSet<String>();
        EntityExpr condition = new EntityExpr("oldIssueKey", EntityOperator.IN, keys);
        Select.from(Entity.MOVED_ISSUE_KEY).whereCondition((EntityCondition)condition).runWith(this.ofBizDelegator).visitWith(new Visitor<MovedIssueKey>(){

            public void visit(MovedIssueKey element) {
                movedIssueKeys.add(element.getOldIssueKey());
            }
        });
        return movedIssueKeys;
    }

    @Override
    public void deleteMovedIssueKeyHistory(Long issueId) {
        this.entityEngine.delete(Delete.from(Entity.MOVED_ISSUE_KEY).whereEqual("issueId", issueId));
    }
}

