/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.RecentCommentManager;
import com.atlassian.jira.issue.comments.util.CommentIterator;
import com.atlassian.jira.issue.renderers.CommentFieldRenderContext;
import com.atlassian.jira.issue.renderers.FieldRenderContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.util.RssViewUtils;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.issue.views.util.WordViewUtils;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.PagerFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SearchRequestRecentCommentsView
extends AbstractSearchRequestView {
    public static final String DEFAULT_DESCRIPTION = "An XML representation of a search request";
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final RendererManager rendererManager;
    private final RecentCommentManager recentCommentManager;
    private final BuildUtilsInfo buildUtilsInfo;

    public SearchRequestRecentCommentsView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, RendererManager rendererManager, RecentCommentManager recentCommentManager, BuildUtilsInfo buildUtilsInfo) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.rendererManager = rendererManager;
        this.recentCommentManager = recentCommentManager;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders) {
        WordViewUtils.writeGenericNoCacheHeaders(requestHeaders);
    }

    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) throws SearchException {
        SearchRequestRecentCommentsView commentView = this.getRecentCommentsView();
        try (CommentIterator recentComments = null;){
            if (commentView == null) {
                writer.write("Could not find plugin of class 'SearchRequestRecentCommentsView'.  This is needed for this plugin to work");
                return;
            }
            recentComments = this.recentCommentManager.getRecentComments(searchRequest, this.authenticationContext.getUser());
            PagerFilter pagerFilter = searchRequestParams.getPagerFilter();
            writer.write(this.getHeader(searchRequest, pagerFilter, recentComments.size()));
            this.writeBody(recentComments, writer, pagerFilter);
            writer.write(this.getFooter());
        }
    }

    private SearchRequestRecentCommentsView getRecentCommentsView() {
        return SearchRequestViewUtils.getSearchRequestView(SearchRequestRecentCommentsView.class);
    }

    private void writeBody(CommentIterator recentComments, Writer writer, PagerFilter pagerFilter) {
        for (int traversedComments = 0; recentComments.hasNext() && traversedComments < pagerFilter.getEnd(); ++traversedComments) {
            Comment comment = (Comment)recentComments.next();
            this.writeAction(writer, comment);
        }
    }

    private void writeAction(Writer writer, Comment comment) {
        Map<String, Object> actionParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        actionParams.put("issue", comment.getIssue());
        actionParams.put("description", this.getActionHtml(comment));
        actionParams.put("comment", comment);
        try {
            writer.write(this.descriptor.getHtml("view", actionParams));
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private String getActionHtml(Comment comment) {
        return this.rendererManager.getRenderedContent((FieldRenderContext)new CommentFieldRenderContext(comment));
    }

    private String getHeader(SearchRequest searchRequest, PagerFilter pagerFilter, int totalComments) {
        long startComment = pagerFilter.getStart();
        long tempMax = pagerFilter.getMax() < 0 ? 0L : (long)pagerFilter.getMax();
        long endComment = Math.min(startComment + tempMax, (long)totalComments);
        Map<String, Object> headerParams = JiraVelocityUtils.getDefaultVelocityParams(new HashMap<String, Object>(), this.authenticationContext);
        headerParams.put("title", SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getString("jira.title")));
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        headerParams.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getUser()));
        headerParams.put("buildInfo", this.buildUtilsInfo.getBuildInformation());
        headerParams.put("currentDate", new Date());
        headerParams.put("description", this.getDescription(searchRequest));
        headerParams.put("rssLocale", RssViewUtils.getRssLocale(this.authenticationContext.getLocale()));
        headerParams.put("startcomment", startComment);
        headerParams.put("endcomment", endComment);
        headerParams.put("totalcomment", totalComments);
        headerParams.put("version", this.buildUtilsInfo.getVersion());
        headerParams.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        headerParams.put("buildDate", new SimpleDateFormat("dd-MM-yyyy").format(this.buildUtilsInfo.getCurrentBuildDate()));
        return this.descriptor.getHtml("header", headerParams);
    }

    private String getDescription(SearchRequest searchRequest) {
        return searchRequest.getDescription() != null ? searchRequest.getDescription() : DEFAULT_DESCRIPTION;
    }

    public String getFooter() {
        return this.descriptor.getHtml("footer", Collections.emptyMap());
    }
}

