/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.worklog;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.worklog.DeletedWorklog;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.entity.EntityPagedList;
import com.atlassian.jira.entity.WorklogEntityFactory;
import com.atlassian.jira.event.worklog.WorklogDeletedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.worklog.TimeTrackingIssueUpdater;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.issue.worklog.WorklogStore;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.PagedList;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorklogManager
implements WorklogManager,
GroupConfigurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorklogManager.class);
    private final ProjectRoleManager projectRoleManager;
    private final WorklogStore worklogStore;
    private final TimeTrackingIssueUpdater timeTrackingIssueUpdater;
    private final EventPublisher eventPublisher;

    public DefaultWorklogManager(ProjectRoleManager projectRoleManager, WorklogStore worklogStore, TimeTrackingIssueUpdater timeTrackingIssueUpdater, EventPublisher eventPublisher) {
        this.projectRoleManager = projectRoleManager;
        this.worklogStore = worklogStore;
        this.timeTrackingIssueUpdater = timeTrackingIssueUpdater;
        this.eventPublisher = eventPublisher;
    }

    public boolean delete(ApplicationUser user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, false);
        boolean isWorklogDeleted = this.worklogStore.delete(worklog.getId());
        if (isWorklogDeleted) {
            this.timeTrackingIssueUpdater.updateIssueOnWorklogDelete(user, worklog, newEstimate, dispatchEvent);
        }
        return isWorklogDeleted;
    }

    public Worklog create(ApplicationUser user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, true);
        Worklog newWorklog = this.worklogStore.create(worklog);
        this.timeTrackingIssueUpdater.updateIssueOnWorklogCreate(user, newWorklog, newEstimate, dispatchEvent);
        return newWorklog;
    }

    public Worklog update(ApplicationUser user, Worklog worklog, Long newEstimate, boolean dispatchEvent) {
        this.validateWorklog(worklog, false);
        Worklog originalWorklog = this.getById(worklog.getId());
        if (originalWorklog == null) {
            throw new IllegalArgumentException("Unable to find a worklog in the datastore for the provided id: '" + worklog.getId() + "'");
        }
        Long originalTimeSpent = originalWorklog.getTimeSpent();
        Worklog newWorklog = this.worklogStore.update(worklog);
        this.timeTrackingIssueUpdater.updateIssueOnWorklogUpdate(user, originalWorklog, newWorklog, originalTimeSpent, newEstimate, dispatchEvent);
        return newWorklog;
    }

    public Worklog getById(Long id) {
        return this.worklogStore.getById(id);
    }

    public List<Worklog> getByIssue(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Cannot resolve worklogs for null issue.");
        }
        return this.worklogStore.getByIssue(issue);
    }

    public PagedList<Worklog> getByIssue(Issue issue, int pageSize) {
        WorklogEntityFactory worklogEntityFactory = new WorklogEntityFactory(issue, this.projectRoleManager);
        EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), EntityOperator.EQUALS);
        ArrayList orderBy = Lists.newArrayList((Object[])new String[]{"created"});
        return new EntityPagedList<Worklog>(pageSize, worklogEntityFactory, (EntityCondition)condition, orderBy);
    }

    public int swapWorklogGroupRestriction(String groupName, String swapGroup) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        if (swapGroup == null) {
            throw new IllegalArgumentException("You must provide a non null swap group name.");
        }
        return this.worklogStore.swapWorklogGroupRestriction(groupName, swapGroup);
    }

    public long getCountForWorklogsRestrictedByGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("You must provide a non null group name.");
        }
        return this.worklogStore.getCountForWorklogsRestrictedByGroup(groupName);
    }

    public long getCountForWorklogsRestrictedByRole(Long roleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("You must provide a non null role id.");
        }
        return this.worklogStore.getCountForWorklogsRestrictedByRole(roleId);
    }

    public int swapWorklogRoleRestriction(Long roleId, Long swapRoleId) {
        if (roleId == null) {
            throw new IllegalArgumentException("You must provide a non null role id.");
        }
        if (swapRoleId == null) {
            throw new IllegalArgumentException("You must provide a non null swap role id.");
        }
        return this.worklogStore.swapWorklogRoleRestriction(roleId, swapRoleId);
    }

    public ProjectRole getProjectRole(Long projectRoleId) {
        return this.projectRoleManager.getProjectRole(projectRoleId);
    }

    public List<Worklog> getWorklogsUpdatedSince(Long sinceInMilliseconds) {
        Preconditions.checkArgument((sinceInMilliseconds != null ? 1 : 0) != 0, (Object)"The time in milliseconds must not be null.");
        return this.worklogStore.getWorklogsUpdateSince(sinceInMilliseconds, 1000);
    }

    public List<DeletedWorklog> getWorklogsDeletedSince(Long sinceInMilliseconds) {
        Preconditions.checkArgument((sinceInMilliseconds != null ? 1 : 0) != 0, (Object)"The time in milliseconds must not be null.");
        return this.worklogStore.getWorklogsDeletedSince(sinceInMilliseconds, 1000);
    }

    public Set<Worklog> getWorklogsForIds(Set<Long> idsOfWorklogs) {
        Preconditions.checkArgument((idsOfWorklogs != null ? 1 : 0) != 0, (Object)"Ids of worklogs must not be null.");
        Preconditions.checkArgument((idsOfWorklogs.size() <= 1000 ? 1 : 0) != 0, (Object)"The size of set with ids must less than 1000");
        return this.worklogStore.getWorklogsForIds(idsOfWorklogs, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorklogsForIssue(Issue issue) {
        Transaction transaction = Txn.begin();
        try {
            List<Worklog> worklogsForIssue = this.worklogStore.getByIssue(issue);
            this.worklogStore.deleteWorklogsForIssue(issue);
            transaction.commit();
            worklogsForIssue.stream().map(WorklogDeletedEvent::new).forEach(arg_0 -> ((EventPublisher)this.eventPublisher).publish(arg_0));
        }
        catch (Exception e) {
            log.error("Error when deleting worklogs for issue " + issue.getId(), (Throwable)e);
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    void validateWorklog(Worklog worklog, boolean create) {
        if (worklog == null) {
            throw new IllegalArgumentException("Worklog must not be null.");
        }
        if (worklog.getIssue() == null) {
            throw new IllegalArgumentException("The worklogs issue must not be null.");
        }
        if (!create && worklog.getId() == null) {
            throw new IllegalArgumentException("Can not modify a worklog with a null id.");
        }
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        return this.worklogStore.getCountForWorklogsRestrictedByGroup(group.getName()) > 0L;
    }
}

