/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.dbquery;

import com.atlassian.jira.jql.query.DbQueryFactoryResult;
import com.google.common.collect.ImmutableList;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class DbQueryFactoryResultQuerydsl
implements DbQueryFactoryResult {
    private final Optional<Predicate> predicate;
    private final List<OrderSpecifier> orderSpecifiers;

    public static Builder builder() {
        return new Builder();
    }

    private DbQueryFactoryResultQuerydsl(@Nonnull Optional<Predicate> predicate, List<OrderSpecifier> orderSpecifiers) {
        this.predicate = predicate;
        this.orderSpecifiers = orderSpecifiers;
    }

    Optional<Predicate> getPredicate() {
        return this.predicate;
    }

    public List<OrderSpecifier> getOrderSpecifiers() {
        return this.orderSpecifiers;
    }

    public static DbQueryFactoryResultQuerydsl createFalseResult() {
        return new DbQueryFactoryResultQuerydsl(Optional.of(ExpressionUtils.isNotNull((Expression)NullExpression.DEFAULT)), (List<OrderSpecifier>)ImmutableList.of());
    }

    public DbQueryFactoryResultQuerydsl and(DbQueryFactoryResultQuerydsl result) {
        return this.combineResult(result, BooleanBuilder::and);
    }

    public DbQueryFactoryResultQuerydsl or(DbQueryFactoryResultQuerydsl result) {
        return this.combineResult(result, BooleanBuilder::or);
    }

    private DbQueryFactoryResultQuerydsl combineResult(DbQueryFactoryResultQuerydsl result, Combiner combiner) {
        ArrayList<OrderSpecifier> combinedOrderSpecifiers = new ArrayList<OrderSpecifier>(this.orderSpecifiers);
        combinedOrderSpecifiers.addAll(result.orderSpecifiers);
        if (this.predicate.isPresent()) {
            BooleanBuilder booleanBuilder = new BooleanBuilder(this.predicate.get());
            return new Builder().withPredicate((Predicate)combiner.apply(booleanBuilder, result.getPredicate().orElse(null))).withOrderBy(combinedOrderSpecifiers).build();
        }
        return new Builder().withPredicate(result.getPredicate().orElse(null)).withOrderBy(combinedOrderSpecifiers).build();
    }

    public static class Builder {
        private Predicate predicate;
        private List<OrderSpecifier> orderSpecifiers = Collections.emptyList();

        public Builder withPredicate(Predicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder withOrderBy(List<OrderSpecifier> orderSpecifiers) {
            this.orderSpecifiers = orderSpecifiers;
            return this;
        }

        public DbQueryFactoryResultQuerydsl build() {
            return new DbQueryFactoryResultQuerydsl(Optional.ofNullable(this.predicate), this.orderSpecifiers);
        }
    }

    private static interface Combiner {
        public BooleanBuilder apply(BooleanBuilder var1, Predicate var2);
    }
}

