/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import java.util.List;

@ExperimentalApi
public class AnonymizingClauseVisitor
implements ClauseVisitor<String> {
    private final CustomFieldManager customFieldManager;

    public AnonymizingClauseVisitor(CustomFieldManager customFieldManager) {
        this.customFieldManager = customFieldManager;
    }

    public String visit(AndClause andClause) {
        return this.dealWithCompoundClause(andClause.getClauses(), "AND");
    }

    public String visit(NotClause notClause) {
        return "NOT " + (String)notClause.getSubClause().accept((ClauseVisitor)this);
    }

    public String visit(OrClause orClause) {
        return this.dealWithCompoundClause(orClause.getClauses(), "OR");
    }

    public String visit(TerminalClause clause) {
        return String.format("%s %s %s", this.sanitizeFieldName(this.getName(clause)), clause.getOperator().getDisplayString(), this.getPlaceholdersForOperand(clause.getOperand()));
    }

    public String visit(WasClause clause) {
        return this.sanitizeFieldName(clause.getField()) + " WAS " + this.getPlaceholdersForOperand(clause.getOperand());
    }

    public String visit(ChangedClause clause) {
        return this.sanitizeFieldName(clause.getField()) + " CHANGED";
    }

    private String dealWithCompoundClause(List<Clause> clauses, String clauseName) {
        if (clauses.size() < 2) {
            throw new IllegalArgumentException("Compound clauses must contain at least 2 subClauses");
        }
        String result = String.format("%s %s %s", clauses.get(0).accept((ClauseVisitor)this), clauseName, clauses.get(1).accept((ClauseVisitor)this));
        for (int i = 2; i < clauses.size(); ++i) {
            result = this.combineTwoClauses(result, (String)clauses.get(i).accept((ClauseVisitor)this), clauseName);
        }
        return result;
    }

    private String combineTwoClauses(String left, String right, String clauseName) {
        return String.format("%s %s %s", left, clauseName, right);
    }

    private String getPlaceholdersForOperand(Operand operand) {
        StringBuilder builder = new StringBuilder("?");
        if (operand instanceof MultiValueOperand) {
            int operandCount = 0;
            List operands = ((MultiValueOperand)operand).getValues();
            for (Operand op : operands) {
                if (op instanceof MultiValueOperand) {
                    operandCount += ((MultiValueOperand)op).getValues().size();
                    continue;
                }
                ++operandCount;
            }
            for (int i = 1; i < operandCount; ++i) {
                builder.append(", ?");
            }
        }
        return builder.toString();
    }

    private String getName(TerminalClause clause) {
        String replacement = "";
        if (clause.getProperty().isDefined()) {
            Property p = (Property)clause.getProperty().get();
            int numKeys = p.getKeys().size();
            replacement = this.getPlaceholdersForProperty(numKeys);
        }
        return clause.getName() + replacement;
    }

    private String getPlaceholdersForProperty(int numKeys) {
        String replacement = "[?";
        for (int i = 1; i < numKeys; ++i) {
            replacement = replacement + ", ?";
        }
        return replacement + "]";
    }

    private String sanitizeFieldName(String name) {
        if (SystemSearchConstants.isSystemName((String)name)) {
            return name;
        }
        CustomField cf = this.customFieldManager.getCustomFieldObjectByName(name);
        if (cf != null) {
            return cf.getClauseNames().getPrimaryName();
        }
        return name;
    }
}

