/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.query.QueryVisitor;
import com.atlassian.jira.jql.resolver.SavedFilterResolver;
import com.atlassian.jira.jql.validator.SavedFilterCycleDetector;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InjectableComponent
public class SavedFilterClauseQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(SavedFilterClauseQueryFactory.class);
    private final SavedFilterResolver savedFilterResolver;
    private final JqlOperandResolver jqlOperandResolver;
    private final SavedFilterCycleDetector savedFilterCycleDetector;
    private final QueryVisitor queryVisitor;

    public SavedFilterClauseQueryFactory(SavedFilterResolver savedFilterResolver, JqlOperandResolver jqlOperandResolver, SavedFilterCycleDetector savedFilterCycleDetector, QueryVisitor queryVisitor) {
        this.savedFilterResolver = savedFilterResolver;
        this.jqlOperandResolver = jqlOperandResolver;
        this.savedFilterCycleDetector = savedFilterCycleDetector;
        this.queryVisitor = queryVisitor;
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        boolean mustNotOccur;
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        if (!OperatorClasses.EQUALITY_OPERATORS.contains(terminalClause.getOperator())) {
            return QueryFactoryResult.createFalseResult();
        }
        List rawValues = this.jqlOperandResolver.getValues(queryCreationContext, terminalClause.getOperand(), terminalClause);
        List<SearchRequest> matchingFilters = queryCreationContext.isSecurityOverriden() ? this.savedFilterResolver.getSearchRequestOverrideSecurity(rawValues) : this.savedFilterResolver.getSearchRequest(queryCreationContext.getUser(), rawValues);
        ArrayList queries = Lists.newArrayListWithCapacity((int)matchingFilters.size());
        for (SearchRequest filter : matchingFilters) {
            if (this.savedFilterCycleDetector.containsSavedFilterReference(queryCreationContext.getQueryUser(), queryCreationContext.isSecurityOverriden(), filter, null)) {
                log.debug(String.format("Saved filter with id '%d' contains a reference to itself; a query cannot be generated from this.", filter.getId()));
                return QueryFactoryResult.createFalseResult();
            }
            queries.add(this.getQueryFromSavedFilter(queryCreationContext, filter));
        }
        Operator operator = terminalClause.getOperator();
        boolean bl = mustNotOccur = Operator.NOT_EQUALS == operator || Operator.NOT_IN == operator;
        if (queries.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        if (queries.size() == 1) {
            return new QueryFactoryResult((Query)queries.get(0), mustNotOccur);
        }
        BooleanQuery boolQuery = new BooleanQuery();
        for (Query query : queries) {
            boolQuery.add(query, BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)boolQuery, mustNotOccur);
    }

    Query getQueryFromSavedFilter(QueryCreationContext queryCreationContext, SearchRequest savedFilter) {
        if (savedFilter.getQuery().getWhereClause() == null) {
            return new MatchAllDocsQuery();
        }
        return this.queryVisitor.createQuery(savedFilter.getQuery().getWhereClause(), queryCreationContext);
    }
}

