/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

class MovedIssueValidator {
    private final Set<Operator> supportedOperators;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final I18nHelper.BeanFactory i18nFactory;

    public MovedIssueValidator(Set<Operator> operatorsSupportingMovedIssues, MovedIssueKeyStore movedIssueKeyStore, I18nHelper.BeanFactory i18nFactory) {
        this.movedIssueKeyStore = movedIssueKeyStore;
        this.i18nFactory = i18nFactory;
        this.supportedOperators = Sets.immutableEnumSet(operatorsSupportingMovedIssues);
    }

    public MessageSet validate(ApplicationUser searcher, String key, TerminalClause terminalClause) {
        return this.validate(searcher, new HashSet<String>(Arrays.asList(key)), terminalClause);
    }

    public MessageSet validate(ApplicationUser searcher, Set<String> keys, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (this.isSupported(operator)) {
            return new MessageSetImpl();
        }
        return this.validateMovedIssue(searcher, keys, operator);
    }

    private MessageSet validateMovedIssue(ApplicationUser searcher, Set<String> keys, Operator operator) {
        MessageSetImpl messageSet = new MessageSetImpl();
        Set<String> movedIssueKeys = this.getMovedIssues(keys);
        for (String movedIssueKey : movedIssueKeys) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.movedissue", movedIssueKey, operator.getDisplayString()));
        }
        return messageSet;
    }

    private boolean isSupported(Operator operator) {
        return this.supportedOperators.contains(operator);
    }

    private Set<String> getMovedIssues(Set<String> keys) {
        HashSet<String> upperCaseIssueKeys = new HashSet<String>();
        for (String key : keys) {
            upperCaseIssueKeys.add(key.toUpperCase(Locale.ENGLISH));
        }
        return this.movedIssueKeyStore.getMovedIssueKeys(upperCaseIssueKeys);
    }
}

